/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteredIterable<T>
implements Iterable<T> {
    private final Iterable<T> original;
    private final Predicate<T> filter;

    public FilteredIterable(Iterable<T> original, Predicate<T> filter) {
        this.original = original;
        this.filter = filter;
    }

    protected Predicate<T> getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator(this.original.iterator());
    }

    private class FilteredIterator
    implements Iterator<T> {
        private final Iterator<T> unfiltered;
        private T next;

        public FilteredIterator(Iterator<T> unfiltered) {
            this.unfiltered = unfiltered;
            this.next = this.findNext();
        }

        private T findNext() {
            Object result = null;
            while (null != (result = (Object)this.nextOriginal()) && !this.isIncluded(result)) {
            }
            return result;
        }

        private T nextOriginal() {
            if (this.unfiltered.hasNext()) {
                return this.unfiltered.next();
            }
            return null;
        }

        protected boolean isIncluded(T element) {
            if (null == FilteredIterable.this.getFilter()) {
                return true;
            }
            return FilteredIterable.this.getFilter().test(element);
        }

        @Override
        public boolean hasNext() {
            return null != this.next;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in filtered iterator.");
            }
            Object result = this.next;
            this.next = this.findNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterable is derived and cannot remove elements.");
        }
    }
}

