/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterable;

import java.util.Iterator;
import java.util.function.Supplier;

public class AmountOf<T>
implements Iterable<T> {
    private final Supplier<T> supplier;
    private final int amount;

    public AmountOf(int amount, Supplier<T> supplier) {
        this.amount = amount;
        this.supplier = supplier;
    }

    protected Supplier<T> supplier() {
        return this.supplier;
    }

    protected int maximum() {
        return this.amount;
    }

    @Override
    public Iterator<T> iterator() {
        return new AmountIterator();
    }

    private class AmountIterator
    implements Iterator<T> {
        private int current = 0;

        @Override
        public boolean hasNext() {
            return this.current < AmountOf.this.maximum();
        }

        @Override
        public T next() {
            Object result = AmountOf.this.supplier().get();
            ++this.current;
            return result;
        }
    }
}

