/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import java.util.List;
import java.util.Random;

public final class RandomEntryOf<T> {
    private final List<T> elements;

    private RandomEntryOf(List<T> list) {
        this.elements = list;
    }

    public T using(Random random) {
        return this.elements.get(random.nextInt(this.elements.size()));
    }

    public T withoutGivenRandom() {
        return this.using(new Random());
    }

    public static <T> RandomEntryOf<T> array(T[] array) {
        return new RandomEntryOf<T>(List.of(array));
    }

    public static <T> RandomEntryOf<T> list(List<T> list) {
        return new RandomEntryOf<T>(list);
    }

    public static <T> RandomEntryOf<T> iterable(Iterable<T> iterable) {
        return new RandomEntryOf<T>(IterableUtil.asList(iterable));
    }
}

