/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes;

import com.schneide.base.random.RandomnessGenerator;

public class IdentifierGenerator {
    private final String prefix;
    private final String suffix;
    private long index;

    public IdentifierGenerator() {
        this(IdentifierGenerator.getRandomStartIndex());
    }

    private static int getRandomStartIndex() {
        int nextInt = RandomnessGenerator.getInstance().getRandom().nextInt();
        if (Integer.MIN_VALUE == nextInt) {
            nextInt = IdentifierGenerator.getRandomStartIndex();
        }
        return Math.abs(nextInt);
    }

    public IdentifierGenerator(int index) {
        this(index, "");
    }

    public IdentifierGenerator(String prefix) {
        this(prefix, "");
    }

    public IdentifierGenerator(String prefix, String suffix) {
        this(IdentifierGenerator.getRandomStartIndex(), prefix, suffix);
    }

    public IdentifierGenerator(int index, String prefix) {
        this(index, prefix, "");
    }

    public IdentifierGenerator(int index, String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.index = index;
    }

    private String getPrefix() {
        return this.prefix;
    }

    private String getSuffix() {
        return this.suffix;
    }

    private long getCurrentIndex() {
        return this.index;
    }

    private void increaseCurrentIndex() {
        ++this.index;
    }

    public synchronized String getNextIdentifier() {
        StringBuffer result = new StringBuffer();
        result.append(this.getPrefix());
        result.append(this.getCurrentIndex());
        result.append(this.getSuffix());
        this.increaseCurrentIndex();
        return result.toString();
    }
}

