/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes;

import com.schneide.base.logging.LoggedObject;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jdom2.Element;

public abstract class AbstractDataParser
extends LoggedObject {
    protected static int parseIntegerElement(Element element) throws ParseException {
        try {
            return Integer.parseInt(AbstractDataParser.parseStringElement(element));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    protected static double parseDoubleElement(Element element) throws ParseException {
        try {
            return Double.parseDouble(AbstractDataParser.parseStringElement(element));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    protected static boolean parseBooleanElement(Element element) {
        return Boolean.parseBoolean(AbstractDataParser.parseStringElement(element));
    }

    protected static Date parseDateElement(Element element) throws ParseException {
        return AbstractDataParser.getDateFormat().parse(AbstractDataParser.parseStringElement(element));
    }

    protected static String parseStringElement(Element element) {
        return element.getText();
    }

    protected static Element[] toElementArray(List<?> nodeList) {
        return nodeList.toArray(new Element[nodeList.size()]);
    }

    protected static Element factorBooleanElement(boolean value, String elementKey) {
        return AbstractDataParser.factorStringElement(String.valueOf(value), elementKey);
    }

    protected static Element factorDateElement(Date value, String elementKey) {
        return AbstractDataParser.factorStringElement(AbstractDataParser.getDateFormat().format(value), elementKey);
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm");
    }

    protected static Element factorIntegerElement(int value, String elementKey) {
        return AbstractDataParser.factorStringElement(String.valueOf(value), elementKey);
    }

    protected static Element factorDoubleElement(double value, String elementKey) {
        return AbstractDataParser.factorStringElement(String.valueOf(value), elementKey);
    }

    protected static Element factorStringElement(String value, String elementKey) {
        Element element = new Element(elementKey);
        element.setText(value);
        return element;
    }
}

