/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.crypto;

import com.schneide.base.io.virtual.VirtualFile;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Checksum {
    private Checksum() {
    }

    public static String sha256For(VirtualFile datei) throws IOException {
        try (InputStream input = datei.getInputStream();){
            String string = Checksum.checksummeF\u00fcr(input, "SHA-256");
            return string;
        }
    }

    private static String checksummeF\u00fcr(InputStream input, String algorithmus) throws IOException {
        try {
            MessageDigest shaDigest = MessageDigest.getInstance(algorithmus);
            return Checksum.checksummeF\u00fcr(input, shaDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Cannot create checksum, algorithm " + algorithmus + " is missing.", e);
        }
    }

    private static String checksummeF\u00fcr(InputStream input, MessageDigest digest) throws IOException {
        try (BufferedInputStream buffer = new BufferedInputStream(input);){
            byte[] byteArray = new byte[1024];
            int bytesCount = 0;
            while ((bytesCount = buffer.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
            byte[] bytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
    }
}

