/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.editor.QuantityPropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.util.Parameter;

public class QuantityPropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "Quantity";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public double parse(String key, String value) throws MalformedConfigurationEntryException {
        Parameter.isPresent(value);
        Parameter.isPresent(key);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            throw this.malformedEntry(key, value);
        }
    }

    @Override
    public boolean isLikely(String key, String value) {
        return key.endsWith(".value") || super.isLikely(key, value);
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new QuantityPropertyEditor(key, this.parse(key, value), "unit");
    }
}

