/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.LongPropertyEditor;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.util.Parameter;

public class LongPropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "Long";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public long parse(String key, String value) throws MalformedConfigurationEntryException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            throw this.malformedEntry(key, value);
        }
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new LongPropertyEditor(key, this.parse(key, value));
    }
}

