/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.IntegerPropertyEditor;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.util.Parameter;

public class IntegerPropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "Integer";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public int parse(String key, String value) throws MalformedConfigurationEntryException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            throw this.malformedEntry(key, value);
        }
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new IntegerPropertyEditor(key, this.parse(key, value));
    }
}

