/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.FilePropertyEditor;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.util.Parameter;
import java.io.File;

public class FilePropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "File";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public File parse(String key, String value) throws MalformedConfigurationEntryException {
        Parameter.isPresent(value);
        Parameter.isPresent(key);
        File result = ClassLoader.getSystemResource(value) == null ? new File(value) : FileLocator.getFile(value);
        if (result.isDirectory() || value.indexOf(".") == -1) {
            throw this.malformedEntry(key, value);
        }
        return result;
    }

    @Override
    public boolean isLikely(String key, String value) {
        return key.endsWith(".file") || super.isLikely(key, value);
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new FilePropertyEditor(key, this.parse(key, value));
    }
}

