/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.DirectoryPropertyEditor;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.io.file.FileUtil;
import com.schneide.base.util.Parameter;
import java.io.File;

public class DirectoryPropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "Directory";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public File parse(String key, String value) throws MalformedConfigurationEntryException {
        Parameter.isPresent(value);
        Parameter.isPresent(key);
        String filename = value.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File result = new File(filename);
        if (result.exists()) {
            if (!result.isDirectory() || filename.indexOf(".") == 1) {
                throw this.malformedEntry(key, value);
            }
        } else {
            FileUtil.ensureSuccessWithWarning("Error while creating dir for config", this.createDirectory(result));
        }
        return result;
    }

    protected boolean createDirectory(File directory) {
        return directory.mkdirs();
    }

    @Override
    public boolean isLikely(String key, String value) {
        Parameter.isPresent(key);
        return key.endsWith(".directory") || super.isLikely(key, value);
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new DirectoryPropertyEditor(key, this.parse(key, value));
    }
}

