/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.parsers;

import com.schneide.base.configuration.MalformedConfigurationEntryException;
import com.schneide.base.configuration.editor.BooleanPropertyEditor;
import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.applicationLevel.BooleanSyntax;

public class BooleanPropertyParser
extends PropertyParser {
    @Override
    public String getTypeIdentifier() {
        return "Boolean";
    }

    @Override
    protected boolean checkValue(String key, String value) throws MalformedConfigurationEntryException {
        this.parse(key, value);
        return true;
    }

    public boolean parse(Property property) throws MalformedConfigurationEntryException {
        return this.parse(property.getKey(), property.getValue());
    }

    public boolean parse(String key, String value) throws MalformedConfigurationEntryException {
        for (BooleanSyntax element : BooleanSyntax.DEFAULT) {
            if (element.isPositiveValue(value)) {
                return true;
            }
            if (!element.isNegativeValue(value)) continue;
            return false;
        }
        throw this.malformedEntry(key, value);
    }

    @Override
    public boolean isLikely(String key, String value) {
        return key.endsWith(".enabled") || super.isLikely(key, value);
    }

    @Override
    public PropertyEditor getEditor(String key, String value) {
        return new BooleanPropertyEditor(key, this.parse(key, value));
    }
}

