/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.domain;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;

public final class ConfigurationLocationOf {
    private ConfigurationLocationOf() {
    }

    public static VirtualFile archive() {
        return ConfigurationLocationOf.directoryNamed("archive");
    }

    public static VirtualFile stores() {
        return ConfigurationLocationOf.directoryNamed("stores");
    }

    public static VirtualFile internals() {
        return ConfigurationLocationOf.directoryNamed("internals");
    }

    public static VirtualFile resources() {
        return ConfigurationLocationOf.directoryNamed("resources");
    }

    public static VirtualFile settings() {
        return ConfigurationLocationOf.directoryNamed("settings");
    }

    private static VirtualFile directoryNamed(String name) {
        try {
            return new LocalVirtualFile(name).createAsDirectory();
        }
        catch (IOException e) {
            LoggedObject.getStaticLogger().fatal("Cannot create essential directory " + name, e);
            return null;
        }
    }
}

