/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration;

import com.schneide.base.configuration.ParsedProperties;
import com.schneide.base.configuration.UnreadableConfigurationException;
import com.schneide.base.configuration.UnwriteableConfigurationException;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.transformation.Embrace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Properties;

public class ParsedConfiguration
extends ParsedProperties {
    private static final Charset CONFIGURATION_ENCODING = Encoding.isoLatin1();
    private final VirtualFile configurationFile;

    public ParsedConfiguration(File configFile, String identifier) {
        this(configFile, identifier, true, true);
    }

    public ParsedConfiguration(File configFile, String identifier, boolean isAbsenceFatal) {
        this(configFile, identifier, true, isAbsenceFatal);
    }

    protected ParsedConfiguration(File configFile, String identifier, boolean readOut, boolean absenceIsFatal) {
        this(new LocalVirtualFile(configFile), identifier, readOut, absenceIsFatal);
    }

    protected ParsedConfiguration(VirtualFile configFile, String identifier, boolean readOut, boolean absenceIsFatal) {
        super(identifier);
        this.configurationFile = configFile;
        if (readOut) {
            try {
                this.readProperties();
                this.readOutProperties();
            }
            catch (UnreadableConfigurationException e) {
                DirectChunkBuffer buffer = new DirectChunkBuffer(" ");
                buffer.add("Die");
                buffer.add(identifier);
                buffer.add(Embrace.withRoundBrackets(configFile.getAbsoluteName()));
                buffer.add("konnten nicht gelesen werden.");
                if (absenceIsFatal) {
                    this.getLogger().fatal(((Object)buffer).toString(), e);
                }
                this.getLogger().warn(((Object)buffer).toString(), e);
            }
        }
    }

    public ParsedConfiguration(Properties properties, File targetFile, String identifier) {
        this(properties, new LocalVirtualFile(targetFile), identifier);
    }

    public ParsedConfiguration(Properties properties, VirtualFile targetFile, String identifier) {
        super(identifier);
        this.configurationFile = targetFile;
        this.setNewProperties(properties);
        this.uncriticalWriteProperties();
    }

    protected void readProperties() throws UnreadableConfigurationException {
        try {
            this.createNewProperties();
            try (InputStream input = this.configurationFile.getInputStream();
                 InputStreamReader reader = new InputStreamReader(input, CONFIGURATION_ENCODING);){
                this.loadPropertiesFrom(reader);
            }
        }
        catch (FileNotFoundException e) {
            this.createUnreadableConfigurationException("konnte nicht gefunden werden.");
        }
        catch (IOException e) {
            this.createUnreadableConfigurationException("konnte nicht ausgelesen werden.");
        }
    }

    private void createUnreadableConfigurationException(String mainMessagePart) throws UnreadableConfigurationException {
        DirectChunkBuffer message = new DirectChunkBuffer(" ");
        message.append("Die Konfigurationsdatei");
        message.append(Embrace.withSingleQuotes(this.configurationFile.getAbsoluteName()));
        message.append("f\u00fcr die Konfiguration");
        message.append(Embrace.withSingleQuotes(this.getIdentifier()));
        message.append(mainMessagePart);
        throw new UnreadableConfigurationException(((Object)message).toString());
    }

    public void reloadProperties() throws UnreadableConfigurationException {
        this.readProperties();
    }

    protected void writeProperties() throws UnwriteableConfigurationException {
        try {
            this.configurationFile.getParent().createAsDirectory();
            try (OutputStream output = this.configurationFile.getOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(output, CONFIGURATION_ENCODING);){
                this.storePropertiesTo(writer);
            }
        }
        catch (FileNotFoundException e) {
            this.createUnreadableConfigurationException("konnte nicht zum Schreiben gefunden werden.");
        }
        catch (IOException e) {
            this.createUnreadableConfigurationException("konnte nicht geschrieben werden.");
        }
    }

    public void uncriticalWriteProperties() {
        try {
            this.writeProperties();
        }
        catch (UnwriteableConfigurationException e) {
            this.getLogger().error("Die Konfiguration wurde aufgrund von Fehlern nicht geschrieben.", e);
        }
    }

    protected void readOutProperties() throws UnreadableConfigurationException {
    }
}

