/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration;

import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfigurationDialog {
    private final JDialog dialog;
    private JPanel messagePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private final List<JButton> buttonList = new ArrayList<JButton>();

    public ConfigurationDialog(String title) {
        this.dialog = new JDialog();
        this.dialog.setTitle(title);
        this.dialog.setModal(true);
        this.initDialog();
        this.dialog.setDefaultCloseOperation(0);
    }

    protected final Logger getLogger() {
        return Base.getLogger(this);
    }

    private synchronized void initDialog() {
        this.dialog.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.dialog.getContentPane().add((Component)this.messagePanel, "North");
        this.dialog.getContentPane().add((Component)this.buttonPanel, "South");
        JPanel leftPolster = new JPanel();
        leftPolster.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        this.dialog.getContentPane().add((Component)leftPolster, "West");
        JPanel rightPolster = new JPanel();
        rightPolster.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        this.dialog.getContentPane().add((Component)rightPolster, "East");
    }

    public void setCenterContent(JPanel content) {
        this.dialog.getContentPane().remove(this.contentPanel);
        this.contentPanel = content;
        this.dialog.getContentPane().add(content);
    }

    public JPanel getCenterContent() {
        return this.contentPanel;
    }

    public ConfigurationDialog getThisDialog() {
        return this;
    }

    public void setMessage(String message) {
        this.setMessage(message, Color.BLACK);
    }

    public void setMessage(String message, Color color) {
        if (message == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        ArrayList<String> tokenList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokenList.add(tokenizer.nextToken());
        }
        this.setMessages(tokenList.toArray(new String[tokenList.size()]), color);
    }

    public void setMessages(String[] messages) {
        this.setMessages(messages, Color.BLACK);
    }

    public void setMessages(String[] messages, Color color) {
        JPanel newMessagePanel = new JPanel(new StringGridBagLayout());
        newMessagePanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 10, 12));
        for (int i = 0; i < messages.length; ++i) {
            JLabel messageLabel = new JLabel(messages[i]);
            messageLabel.setForeground(color);
            messageLabel.setHorizontalAlignment(0);
            newMessagePanel.add("gridx=0,gridy=" + i + ",gridwidth=1,gridheight=1,anchor=CENTER,fill=HORIZONTAL,insets=[2,2,2,2]", messageLabel);
        }
        this.dialog.getContentPane().remove(this.messagePanel);
        this.messagePanel = newMessagePanel;
        this.dialog.getContentPane().add((Component)newMessagePanel, "North");
    }

    protected synchronized void updateButtons() {
        JPanel newButtonPanel = new JPanel();
        newButtonPanel.setLayout(new BoxLayout(newButtonPanel, 0));
        newButtonPanel.setBorder(BorderFactory.createEmptyBorder(17, 12, 12, 7));
        newButtonPanel.add(Box.createHorizontalGlue());
        for (AbstractButton abstractButton : this.buttonList) {
            newButtonPanel.add(abstractButton);
            newButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        this.dialog.getContentPane().remove(this.buttonPanel);
        this.buttonPanel = newButtonPanel;
        this.dialog.getContentPane().add((Component)newButtonPanel, "South");
    }

    public synchronized void registerStandardButtons(String string, String string2) {
        JButton newButton = new JButton(string);
        this.buttonList.add(newButton);
        this.updateButtons();
    }

    public JDialog getDialog() {
        return this.dialog;
    }
}

