/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.capability;

import com.schneide.base.capability.CapabilityResource;
import com.schneide.base.capability.CapabilityStorage;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.logging.LoggedObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class Capability
extends LoggedObject {
    private static volatile Set<Class<? extends Capability>> alreadyBooted = new HashSet<Class<? extends Capability>>();
    private final I18Nable denotation;
    private final CapabilityStorage storage;

    public Capability(CapabilityStorage storage, I18Nable denotation) {
        this.storage = storage;
        this.denotation = denotation;
    }

    protected abstract Iterable<CapabilityResource> resources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void boot() {
        Class<?> bootIdentifier = this.getClass();
        Set<Class<? extends Capability>> set = alreadyBooted;
        synchronized (set) {
            if (alreadyBooted.contains(bootIdentifier)) {
                this.getLogger().warn("Capability " + String.valueOf(this.denotation()) + " is already booted.");
                return;
            }
            this.getLogger().info("Booting system capability " + String.valueOf(this.denotation()));
            this.resources().forEach(this.startAndRegister());
            alreadyBooted.add(bootIdentifier);
        }
    }

    private Consumer<CapabilityResource> startAndRegister() {
        Consumer<CapabilityResource> start = CapabilityResource::start;
        Consumer<CapabilityResource> register = this.storage::register;
        return start.andThen(register);
    }

    protected I18Nable denotation() {
        return this.denotation;
    }
}

