/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.shutdown;

import com.schneide.base.io.file.SystemDirectoriesProvider;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.io.writer.WriteTo;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.transformation.Embrace;
import com.schneide.base.text.transformation.IsSurrounded;
import java.io.IOException;

public class RestartTarget
extends LoggedObject {
    public static final String NEXT_START_TARGET_FILENAME = "startnext.txt";
    private final VirtualFile programDirectory;

    public static RestartTarget forWorkingDirectory() {
        return new RestartTarget(new LocalVirtualFile(SystemDirectoriesProvider.getCurrentWorkingDirectory()));
    }

    public RestartTarget(VirtualFile programDirectory) {
        this.programDirectory = programDirectory;
    }

    public void setCommandTo(UpdateCommand newCommand) throws IOException {
        VirtualFile commandFile = this.getCommandFile();
        WriteTo.virtualFile(commandFile).using(writer -> writer.print(this.getCommandString(newCommand.getCommandLine())));
    }

    protected String getCommandString(String command) {
        if (IsSurrounded.byDoubleQuotes(command)) {
            return command;
        }
        return Embrace.withDoubleQuotes(command);
    }

    protected VirtualFile getCommandFile() throws IOException {
        VirtualFile commandFile = this.programDirectory.getChild(NEXT_START_TARGET_FILENAME).createAsFile();
        return commandFile;
    }

    public void removeCommand() throws IOException {
        this.getCommandFile().dispose();
    }

    public void attemptToRemoveCommand() {
        try {
            this.removeCommand();
        }
        catch (IOException e) {
            this.getLogger().warn("Could not remove restart target command.", e);
        }
    }

    public static class UpdateCommand {
        private final String commandLine;

        public UpdateCommand(String commandLine) {
            this.commandLine = commandLine;
        }

        public String getCommandLine() {
            return this.commandLine;
        }
    }
}

