/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleSpecification;
import com.schneide.base.application.module.definition.DefiniertesModul;
import com.schneide.base.threading.delay.Delay;
import java.util.Optional;
import java.util.function.Consumer;

public interface ApplicationModule<M extends ApplicationModule<M>>
extends DefiniertesModul {
    default public String bezeichnung() {
        return this.specification().getDenotation();
    }

    public ModuleSpecification specification();

    public void startModule() throws ModuleException;

    public void stopModule() throws ModuleException;

    public ModuleFactory<M> factory();

    @Override
    public boolean aktiviert();

    public boolean isRunning();

    public Optional<PeriodischeAbfrage<M>> periodischeAbfrage();

    public static class PeriodischeAbfrage<M extends ApplicationModule<M>> {
        private final M instanz;
        private final Delay verz\u00f6gerung;
        private final Consumer<M> abfrage;

        public PeriodischeAbfrage(M instanz, Delay verz\u00f6gerung, Consumer<M> abfrage) {
            this.instanz = instanz;
            this.verz\u00f6gerung = verz\u00f6gerung;
            this.abfrage = abfrage;
        }

        public void frageAb() {
            this.verz\u00f6gerung.performLeading();
            if (this.instanz.isRunning() && this.instanz.aktiviert()) {
                this.abfrage.accept(this.instanz);
            }
            this.verz\u00f6gerung.performTrailing();
        }
    }
}

