/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleBuildInformation;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleSpecification;
import com.schneide.base.logging.LoggedObject;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractModule<M extends ApplicationModule<M>>
extends LoggedObject
implements ApplicationModule<M> {
    private final ModuleSpecification specification;
    private final ModuleFactory<M> factory;
    private volatile boolean isRunning = false;

    public AbstractModule(ModuleBuildInformation<M> buildInfo) {
        this(buildInfo.specification(), buildInfo.factory());
    }

    public AbstractModule(ModuleSpecification specification, ModuleFactory<M> factory) {
        this.specification = specification;
        this.factory = factory;
    }

    @Override
    public ModuleSpecification specification() {
        return this.specification;
    }

    @Override
    public ModuleFactory<M> factory() {
        return this.factory;
    }

    @Override
    public boolean aktiviert() {
        return true;
    }

    public String toString() {
        if (null == this.specification()) {
            return super.toString();
        }
        return this.specification().getDenotation();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public final void startModule() throws ModuleException {
        this.startInternal();
        this.isRunning = true;
    }

    protected abstract void startInternal() throws ModuleException;

    @Override
    public final void stopModule() throws ModuleException {
        this.isRunning = false;
        this.stopInternal();
    }

    protected abstract void stopInternal() throws ModuleException;

    @Override
    public Object definition() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("category", this.kategorie());
        result.put("type", new DenotatedIdentifier(this.specification().getType().getIdentifier(), this.specification().getType().getDenotation()));
        result.put("identifier", this.specification().getIdentifier());
        result.put("denotation", this.specification().getDenotation());
        result.put("mode", new DenotatedIdentifier(this.specification().getMode().getIdentifier(), this.specification().getMode().getDenotation()));
        result.put("isRunning", this.isRunning());
        result.putAll(this.additionalDefinition());
        return result;
    }

    protected abstract String kategorie();

    protected abstract Map<String, Object> additionalDefinition();

    public static final class DenotatedIdentifier {
        private final String identifier;
        private final String denotation;

        public DenotatedIdentifier(String identifier, String denotation) {
            this.identifier = identifier;
            this.denotation = denotation;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDenotation() {
            return this.denotation;
        }
    }
}

