/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.model.repository.excelbased;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.format.excel.Exceldatei;
import com.schneide.werp.periphery.datenimport.lader.ExcelLader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class ExcelbasiertesRepository<Dom\u00e4nentyp>
extends LoggedObject {
    private final Exceldatei excel;

    public ExcelbasiertesRepository(File datei, ExcelLader excel, int anzahlKopfzeilen) throws IOException {
        this.excel = excel.ladenAus(datei).mitKopfzeilen(anzahlKopfzeilen);
    }

    protected Iterable<Exceldatei.Excelzeile> zeilenAus(String tabellenname) {
        return this.zeilenAus((Exceldatei ed) -> ed.tabelleF\u00fcr(tabellenname));
    }

    protected Iterable<Exceldatei.Excelzeile> zeilenAusErsterTabelle() {
        return this.zeilenAus((Exceldatei ed) -> Optional.of(ed.ersteTabelle()));
    }

    protected Iterable<Exceldatei.Exceltabelle> tabellenMitEigenschaft(Predicate<Exceldatei.Exceltabelle> eigenschaft) {
        ArrayList<Exceldatei.Exceltabelle> result = new ArrayList<Exceldatei.Exceltabelle>();
        this.excel.alleTabellen().forEach(t -> {
            if (eigenschaft.test((Exceldatei.Exceltabelle)t)) {
                result.add((Exceldatei.Exceltabelle)t);
            }
        });
        return result;
    }

    private Iterable<Exceldatei.Excelzeile> zeilenAus(Function<Exceldatei, Optional<Exceldatei.Exceltabelle>> tabelle) {
        return tabelle.apply(this.excel).map(t -> t.zeilenNachKopfzeilen()).orElseGet(Collections::emptyList);
    }

    protected Iterable<Dom\u00e4nentyp> interpretiert(Iterable<Exceldatei.Excelzeile> zeilen, Function<Exceldatei.Excelzeile, Optional<Dom\u00e4nentyp>> umwandlung) {
        return this.interpretiert(zeilen, 0, umwandlung);
    }

    protected Iterable<Dom\u00e4nentyp> interpretiert(Iterable<Exceldatei.Excelzeile> zeilen, int kopfzeilen, Function<Exceldatei.Excelzeile, Optional<Dom\u00e4nentyp>> umwandlung) {
        return StreamSupport.stream(zeilen.spliterator(), false).skip(kopfzeilen).map(umwandlung::apply).filter(Optional::isPresent).map(o -> o.get()).collect(Collectors.toList());
    }
}

