/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.widget.generic;

import com.schneide.base.gui.swing.EDT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;

public class MultiComboBox<E extends CheckableItem>
extends JComboBox<E> {
    private static final long serialVersionUID = 5756150770173809107L;
    private final int maximumShownCharacters;
    private final JPanel panel = new JPanel(new BorderLayout());
    protected boolean keepOpen;

    public MultiComboBox(ComboBoxModel<E> model, int maximumShownCharacters) {
        super(model);
        this.maximumShownCharacters = maximumShownCharacters;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 30);
    }

    public Iterable<E> getSelectedItems() {
        EDT.always();
        ComboBoxModel currentModel = this.getModel();
        return IntStream.range(0, currentModel.getSize()).mapToObj(currentModel::getElementAt).filter(CheckableItem::isSelected).collect(Collectors.toList());
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        super.updateUI();
        Accessible a = this.getAccessibleContext().getAccessibleChild(0);
        if (a instanceof ComboPopup) {
            ((ComboPopup)((Object)a)).getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JList list = (JList)e.getComponent();
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        MultiComboBox.this.keepOpen = true;
                        MultiComboBox.this.updateItem(list.locationToIndex(e.getPoint()));
                    }
                }
            });
        }
        DefaultListCellRenderer normalRenderer = new DefaultListCellRenderer();
        JCheckBox check = new JCheckBox();
        check.setOpaque(false);
        this.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            this.panel.removeAll();
            this.panel.setBorder(BorderFactory.createEmptyBorder());
            Component component = normalRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index < 0) {
                JLabel label = (JLabel)component;
                label.setText(this.labeltextFor(list));
                label.setOpaque(false);
                label.setForeground(list.getForeground());
                this.panel.setOpaque(false);
            } else {
                check.setSelected(value.isSelected());
                this.panel.add((Component)check, "West");
                this.panel.setOpaque(true);
                this.panel.setBackground(component.getBackground());
                this.panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            this.panel.add(component, "Center");
            this.panel.revalidate();
            return this.panel;
        });
        this.initActionMap();
    }

    protected String labeltextFor(JList<? extends E> list) {
        String fulltext = MultiComboBox.getCheckedItemString(list.getModel());
        if (fulltext.isEmpty()) {
            return " ";
        }
        if (fulltext.length() <= this.maximumShownCharacters) {
            return fulltext;
        }
        return fulltext.substring(0, this.maximumShownCharacters) + "...";
    }

    protected void initActionMap() {
        KeyStroke ks = KeyStroke.getKeyStroke(32, 0);
        this.getInputMap(0).put(ks, "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){
            private static final long serialVersionUID = 4374621235697836284L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = MultiComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof ComboPopup) {
                    MultiComboBox.this.updateItem(((ComboPopup)((Object)a)).getList().getSelectedIndex());
                }
            }
        });
    }

    protected void updateItem(int index) {
        if (this.isPopupVisible() && index >= 0) {
            CheckableItem item;
            item.setSelected(!(item = (CheckableItem)this.getItemAt(index)).isSelected());
            this.setSelectedIndex(-1);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    protected static <E extends CheckableItem> String getCheckedItemString(ListModel<E> model) {
        return IntStream.range(0, model.getSize()).mapToObj(model::getElementAt).filter(CheckableItem::isSelected).map(CheckableItem::abbreviation).sorted().collect(Collectors.joining(", "));
    }

    public static class CheckableItem {
        private final String text;
        private boolean selected;

        protected CheckableItem(String text, boolean selected) {
            this.text = text;
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String toString() {
            return this.text;
        }

        public String abbreviation() {
            return this.text;
        }
    }

    public static class WindowsCheckedComboBox<E extends CheckableItem>
    extends MultiComboBox<E> {
        private static final long serialVersionUID = 4348678181193804581L;
        private transient ActionListener listener;

        protected WindowsCheckedComboBox(ComboBoxModel<E> model, int maximumShownCharacters) {
            super(model, maximumShownCharacters);
        }

        @Override
        public void updateUI() {
            this.setRenderer(null);
            this.removeActionListener(this.listener);
            super.updateUI();
            this.listener = e -> {
                if (((long)e.getModifiers() & 0x10L) != 0L) {
                    this.keepOpen = true;
                    this.updateItem(this.getSelectedIndex());
                }
            };
            this.addActionListener(this.listener);
            JLabel label = new JLabel(" ");
            JCheckBox check = new JCheckBox(" ");
            this.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
                if (index < 0) {
                    label.setText(this.labeltextFor(list));
                    return label;
                }
                check.setText(Objects.toString(value, ""));
                check.setSelected(value.isSelected());
                if (isSelected) {
                    check.setBackground(list.getSelectionBackground());
                    check.setForeground(list.getSelectionForeground());
                } else {
                    check.setBackground(list.getBackground());
                    check.setForeground(list.getForeground());
                }
                return check;
            });
            this.initActionMap();
        }
    }
}

