/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.widget.generic;

import java.time.Clock;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class Datumsangabe {

    public static class Wochengenau {
        private static final DateTimeFormatter pattern = DateTimeFormatter.ofPattern("ww/YYYY", Locale.GERMAN);
        private final Clock zeitgeber;

        public Wochengenau(Clock zeitgeber) {
            this.zeitgeber = zeitgeber;
        }

        public String absolut(LocalDate datum) {
            return "KW" + pattern.format(datum);
        }

        public String relativ(LocalDate datum) {
            LocalDate jetzt = LocalDate.now(this.zeitgeber);
            long relativeWochen = ChronoUnit.WEEKS.between(jetzt, datum);
            if (relativeWochen == 0L) {
                return "diese Woche";
            }
            if (relativeWochen == 1L) {
                return "n\u00e4chste Woche";
            }
            if (relativeWochen == -1L) {
                return "letzte Woche";
            }
            if (relativeWochen > 0L) {
                return "in " + relativeWochen + " Wochen";
            }
            if (relativeWochen < 0L) {
                return "vor " + Math.abs(relativeWochen) + " Wochen";
            }
            return "FEHLER";
        }

        public String absolutUndRelativ(LocalDate datum) {
            return this.absolut(datum) + " (" + this.relativ(datum) + ")";
        }
    }

    public static class Tagesgenau {
        private static final DateTimeFormatter pattern = DateTimeFormatter.ofPattern("dd.MM.yyyy", Locale.GERMAN);
        private final Clock zeitgeber;

        public Tagesgenau(Clock zeitgeber) {
            this.zeitgeber = zeitgeber;
        }

        public String absolut(LocalDate datum) {
            return pattern.format(datum);
        }

        public String relativ(LocalDate datum) {
            LocalDate jetzt = LocalDate.now(this.zeitgeber);
            long relativeTage = ChronoUnit.DAYS.between(jetzt, datum);
            if (relativeTage == 0L) {
                return "heute";
            }
            if (relativeTage == 1L) {
                return "morgen";
            }
            if (relativeTage == -1L) {
                return "gestern";
            }
            if (relativeTage > 0L) {
                return "in " + relativeTage + " Tagen";
            }
            if (relativeTage < 0L) {
                return "vor " + Math.abs(relativeTage) + " Tagen";
            }
            return "FEHLER";
        }

        public String absolutUndRelativ(LocalDate datum) {
            return this.absolut(datum) + " (" + this.relativ(datum) + ")";
        }
    }
}

