/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.generic;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.werp.domain.session.WerpSession;
import java.awt.Dialog;
import java.util.function.Consumer;
import javax.swing.JPanel;

public abstract class WerpDialog<ANSWER>
extends AbstractSchneideDialog<ANSWER> {
    private final WerpSession session;
    private final I18NResolvable title;

    public WerpDialog(WerpSession session, I18NResolvable title) {
        this(session, title, AbstractSchneideDialog.defaultModality);
    }

    public WerpDialog(WerpSession session, I18NResolvable title, Dialog.ModalityType modality) {
        this(session, session.getMainWindowStack(), title, modality);
    }

    public WerpDialog(WerpSession session, WindowStack windowStack, I18NResolvable title) {
        this(session, windowStack, title, AbstractSchneideDialog.defaultModality);
    }

    public WerpDialog(WerpSession session, WindowStack windowStack, I18NResolvable title, Dialog.ModalityType modality) {
        super(windowStack, modality);
        this.session = session;
        this.title = title;
    }

    protected String getDefaultTitle() {
        return this.title.resolvedText();
    }

    protected WerpSession session() {
        return this.session;
    }

    protected void buildUI() {
        EDT.only();
        JPanel content = new JPanel();
        this.buildContentWithin(content);
        this.setContent(content);
        if (!this.hasButtons()) {
            this.addButton().closeButton();
        }
    }

    protected abstract void buildContentWithin(JPanel var1);

    protected void refreshContentWith(Consumer<JPanel> contentSetup) {
        EDT.only();
        JPanel content = this.getContent();
        content.removeAll();
        contentSetup.accept(content);
        this.repack();
    }
}

