/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.engine.periphery;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.periphery.Periphery;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.periphery.datenimport.Datenimport;
import com.schneide.werp.periphery.datenspeicherung.Datenspeicherung;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import java.util.Optional;

public class PeripherybasierteAnwendungsumgebung
extends LoggedObject
implements Anwendungsumgebung {
    private final Periphery periphery;
    private final Dokumenterstellung shortcut;

    public PeripherybasierteAnwendungsumgebung(Periphery periphery, Dokumenterstellung shortcut) {
        this.periphery = periphery;
        this.shortcut = shortcut;
    }

    @Override
    public Optional<Datenimport> datenimport() {
        return this.aktiver(Datenimport.class);
    }

    @Override
    public Optional<Datenspeicherung> datenspeicherung() {
        return this.aktive(Datenspeicherung.class);
    }

    @Override
    public Optional<Dokumenterstellung> dokumenterstellung() {
        return Optional.ofNullable(this.shortcut);
    }

    private <M extends ApplicationModule<M>> Optional<M> aktive(Class<M> typ) {
        return this.aktiver(typ);
    }

    private <M extends ApplicationModule<M>> Optional<M> aktiver(Class<M> typ) {
        return this.erstesF\u00fcr(typ).filter(ApplicationModule::aktiviert);
    }

    private <M extends ApplicationModule<M>> Optional<M> erstesF\u00fcr(Class<M> typ) {
        return this.periphery.getFirstOf(typ);
    }
}

