/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.event;

import com.schneide.base.eventbus.News;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.benutzer.WerpUser;
import com.schneide.werp.domain.session.WerpSession;
import java.time.LocalDateTime;
import java.util.Optional;

public abstract class DomainEvent<Entity>
extends LoggedObject
implements News {
    private final WerpSession bySession;
    private final LocalDateTime erstellungszeitpunkt;
    private final Class<? extends Entity> entityType;

    public DomainEvent(WerpSession bySession, Class<? extends Entity> entityType) {
        this.bySession = bySession;
        this.entityType = entityType;
        this.erstellungszeitpunkt = LocalDateTime.now(bySession.zeitgeber());
    }

    public WerpSession bySession() {
        return this.bySession;
    }

    public WerpUser byUser() {
        return (WerpUser)this.bySession().getUser();
    }

    public LocalDateTime erstellungszeitpunkt() {
        return this.erstellungszeitpunkt;
    }

    public Class<? extends Entity> betrifftTyp() {
        return this.entityType;
    }

    public abstract Optional<Entity> betrifft();

    public void publish() {
        this.bySession.publish(this);
    }
}

