/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer.speicherung;

import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.io.stream.provider.StreamPair;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.benutzer.speicherung.CredentialPersister;
import com.schneide.werp.domain.benutzer.speicherung.PropertyBasedPersistence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public abstract class EncryptedUserPersister<U extends SchneideUser>
extends LoggedObject
implements SchneideUserHandler<U> {
    private static final String usersPath = String.valueOf(ConfigurationLocationOf.stores()) + "/authentication/users";
    private static final String userFileEnding = ".user";
    private static final String groupPrefix = "group.";
    private final PropertyBasedPersistence persistence;
    private final UserGroupHandler groupHandler;
    private final Set<U> cache;

    public EncryptedUserPersister(UserGroupHandler groupHandler, StreamPair encryption) {
        this.groupHandler = groupHandler;
        this.persistence = new PropertyBasedPersistence(encryption);
        this.cache = new HashSet<U>();
    }

    public void load() throws IOException {
        Iterable allGroups = this.groupHandler.getUserGroups();
        for (VirtualFile each : this.allUserFiles()) {
            Properties properties = this.persistence.loadPropertiesFrom(each);
            U newUser = this.createUserFor(properties.getProperty("login"), properties.getProperty("forename"), properties.getProperty("surname"), new Password(properties.getProperty("password")), Boolean.parseBoolean(properties.getProperty("internal")));
            for (SchneideUserGroup group : this.loadGroupsFrom(properties, allGroups)) {
                newUser.addUserGroup(group);
            }
            Iterable<SchneideCredential> credentials = new CredentialPersister().loadFrom(properties);
            for (SchneideCredential credential : credentials) {
                newUser.addCredential(credential);
            }
            this.cache.add(newUser);
        }
    }

    private Iterable<SchneideUserGroup> loadGroupsFrom(Properties properties, Iterable<SchneideUserGroup> allGroups) {
        ArrayList<SchneideUserGroup> result = new ArrayList<SchneideUserGroup>();
        for (Object each : properties.keySet()) {
            String key = String.valueOf(each);
            if (!key.startsWith(groupPrefix)) continue;
            String groupIdentifier = properties.getProperty(key);
            for (SchneideUserGroup group : allGroups) {
                if (!groupIdentifier.equals(group.getIdentifier())) continue;
                result.add(group);
            }
        }
        return result;
    }

    protected abstract U createUserFor(String var1, String var2, String var3, Password var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(U user) {
        Set<U> set = this.cache;
        synchronized (set) {
            Properties properties = new Properties();
            properties.setProperty("login", user.getLogIn());
            properties.setProperty("forename", user.getForename());
            properties.setProperty("surname", user.getSurname());
            properties.setProperty("password", user.getPassword().asDigest());
            properties.setProperty("internal", Boolean.toString(user.getIsInternal()));
            this.storeGroupReferencesInto(properties, user.getUserGroups());
            new CredentialPersister().storeInto(properties, user.getCredentials());
            this.persist(properties, user);
            this.cache.add(user);
        }
    }

    protected void persist(Properties properties, U user) {
        try {
            VirtualFile target = this.fileFor(user).createAsFile();
            this.persistence.persistTo(properties, target);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Cannot store user information for " + user.getLogIn()), (Throwable)e);
        }
    }

    protected VirtualFile fileFor(U user) throws IOException {
        return this.usersDirectory().createFile(user.getLogIn() + userFileEnding);
    }

    protected VirtualFile usersDirectory() throws IOException {
        return LocalVirtualFile.directoryAt((String)usersPath).createAsDirectory();
    }

    protected Iterable<? extends VirtualFile> allUserFiles() throws IOException {
        return this.usersDirectory().listDirectory(f -> f.getName().endsWith(userFileEnding));
    }

    private void storeGroupReferencesInto(Properties properties, Iterable<SchneideUserGroup> groups) {
        int index = 0;
        for (SchneideUserGroup each : groups) {
            properties.setProperty(groupPrefix + index, each.getIdentifier());
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(U user) {
        Set<U> set = this.cache;
        synchronized (set) {
            try {
                this.fileFor(user).dispose();
                this.cache.remove(user);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Could not delete user information for " + user.getLogIn()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<U> getAll() {
        Set<U> set = this.cache;
        synchronized (set) {
            return new ArrayList<U>(this.cache);
        }
    }
}

