/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer.speicherung;

import com.schneide.base.application.usermanagement.data.CredentialType;
import com.schneide.base.application.usermanagement.data.GenericSchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.werp.domain.benutzer.speicherung.ListedPropertiesPersister;
import java.util.ArrayList;
import java.util.Properties;

public class CredentialPersister {
    private static final String credentialKeyIdentifier = "credential.key";

    public Iterable<SchneideCredential> loadFrom(Properties properties) {
        ArrayList<SchneideCredential> result = new ArrayList<SchneideCredential>();
        for (Object each : properties.keySet()) {
            String key = String.valueOf(each);
            if (!key.startsWith(credentialKeyIdentifier)) continue;
            String credentialKey = properties.getProperty(key);
            String index = key.substring(credentialKeyIdentifier.length());
            CredentialType type = CredentialType.valueOf((String)this.propertyFor("credential.type", index, properties));
            boolean isPermission = Boolean.parseBoolean(this.propertyFor("credential.permission", index, properties));
            String description = this.propertyFor("credential.description", index, properties);
            boolean isInternal = Boolean.parseBoolean(this.propertyFor("credential.internal", index, properties));
            result.add((SchneideCredential)new GenericSchneideCredential(credentialKey, description, type, isInternal, isPermission));
        }
        return result;
    }

    private String propertyFor(String key, String index, Properties properties) {
        return properties.getProperty(key + index);
    }

    public void storeInto(Properties properties, Iterable<SchneideCredential> credentials) {
        ListedPropertiesPersister<SchneideCredential> lister = new ListedPropertiesPersister<SchneideCredential>(properties);
        lister.storeAsList(credentialKeyIdentifier, credentials, SchneideCredential::getKey);
        lister.storeAsList("credential.type", credentials, c -> c.getType().name());
        lister.storeAsList("credential.permission", credentials, c -> Boolean.toString(c.getIsPermission()));
        lister.storeAsList("credential.description", credentials, SchneideCredential::getDescription);
        lister.storeAsList("credential.internal", credentials, c -> Boolean.toString(c.getIsInternal()));
    }
}

