/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.configuration.erstausstattung;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.system.Base;
import com.schneide.werp.configuration.installation.InstallationConfiguration;
import java.io.IOException;
import java.util.Optional;

public class Erstausstattung
extends LoggedObject {
    private final String bezeichnung;

    public static Optional<Erstausstattung> fallsNotwendigLaut(InstallationConfiguration installation, String bezeichnung) {
        if (installation.istProduktivinstanz()) {
            Base.getLogger(Erstausstattung.class).info((Object)("Diese Installation ist im Produktivbetrieb, pr\u00fcfe nicht auf Vorhandensein von " + bezeichnung));
            return Optional.empty();
        }
        return Optional.of(new Erstausstattung(bezeichnung));
    }

    private Erstausstattung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }

    public void anlegenIn(VirtualFile zielverzeichnis) {
        this.getLogger().info((Object)("Lege Erstausstattung von " + this.bezeichnung + " an: " + String.valueOf(zielverzeichnis)));
        LocalVirtualFile vorlage = new LocalVirtualFile("resources/presets/" + zielverzeichnis.getName());
        try {
            this.copyAllFrom((VirtualFile)vorlage, zielverzeichnis);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Konnte die Erstausstattung von " + this.bezeichnung + " nicht anlegen: Fehler beim Kopieren."), (Throwable)e);
        }
    }

    private void copyAllFrom(VirtualFile quelle, VirtualFile ziel) throws IOException {
        ziel.createAsDirectory();
        for (VirtualFile each : quelle.listDirectory(VirtualFileFilter.everything)) {
            if (each.isDirectory()) {
                this.getLogger().debug((Object)("Kopiere Inhalt von " + each.getName()));
                this.copyAllFrom(each, ziel.getChild(each.getName()));
                continue;
            }
            VirtualFile zieldatei = ziel.getChild(each.getName());
            this.getLogger().debug((Object)("Kopiere " + each.getAbsoluteName() + " nach " + zieldatei.getAbsoluteName()));
            each.copyContentTo(zieldatei);
        }
    }
}

