/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.application.configuration.filebased;

import com.schneide.base.configuration.domain.Settings;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.userLevel.Configured;
import com.schneide.werp.application.configuration.AnzeigeConfiguration;
import com.schneide.werp.application.configuration.BetriebConfiguration;
import java.awt.Dimension;
import java.awt.Point;

public class ApplicationConfiguration
extends LoggedObject
implements BetriebConfiguration,
AnzeigeConfiguration {
    private final Configuration configuration;

    public static ApplicationConfiguration standard() {
        return new ApplicationConfiguration(new Configuration(new VirtualFile[]{Settings.inFileAt((String)"application/edition.config"), Settings.inFileAt((String)"application/gui.config")}));
    }

    protected ApplicationConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Dimension mainWindowSize() {
        int width = Configured.entry((String)"main.window.width[pixel]").suffixedWith(this.editionSuffix()).asInt().withFallback(1920).in((ConfigurationPart)this.configuration);
        int height = Configured.entry((String)"main.window.height[pixel]").suffixedWith(this.editionSuffix()).asInt().withFallback(1080).in((ConfigurationPart)this.configuration);
        return new Dimension(width, height);
    }

    @Override
    public Point mainWindowPosition() {
        int horizontal = Configured.entry((String)"main.window.position.horizontal[pixel]").suffixedWith(this.editionSuffix()).asInt().withFallback(0).in((ConfigurationPart)this.configuration);
        int vertical = Configured.entry((String)"main.window.position.vertical[pixel]").suffixedWith(this.editionSuffix()).asInt().withFallback(0).in((ConfigurationPart)this.configuration);
        return new Point(horizontal, vertical);
    }

    @Override
    public boolean mainWindowMaximized() {
        return Configured.entry((String)"main.window.maximized").suffixedWith(this.editionSuffix()).asBoolean().withFallback(true).in((ConfigurationPart)this.configuration);
    }

    @Override
    public boolean mainWindowMinimized() {
        return Configured.entry((String)"main.window.minimized").suffixedWith(this.editionSuffix()).asBoolean().withFallback(false).in((ConfigurationPart)this.configuration);
    }

    @Override
    public boolean loginWindowMinimized() {
        return Configured.entry((String)"login.window.minimized").suffixedWith(this.editionSuffix()).asBoolean().withFallback(false).in((ConfigurationPart)this.configuration);
    }

    @Override
    public boolean istEchtbetrieb() {
        return Configured.entry((String)"echtbetrieb.aktiviert").asBoolean().withFallback(false).in((ConfigurationPart)this.configuration);
    }
}

