/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.application;

import com.schneide.base.application.AbstractApplication;
import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.SystemConfiguration;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.login.LoginHandler;
import com.schneide.base.application.login.SessionAuthentificationLoginHandler;
import com.schneide.base.application.shutdown.ApplicationShutdown;
import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.application.WerpSystemConfiguration;
import com.schneide.werp.domain.benutzer.berechtigung.Berechtigung;
import com.schneide.werp.domain.benutzer.plain.CanDoAll;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.benutzer.plain.SystemUser;
import com.schneide.werp.domain.session.DefaultWerpSession;
import com.schneide.werp.domain.session.WerpSession;
import java.time.Clock;
import java.util.Optional;
import javax.swing.UIManager;

public abstract class WerpApplicationBase
extends AbstractApplication<WerpSession, PlainWerpUser> {
    private final Clock zeitgeber = Clock.systemDefaultZone();

    public WerpApplicationBase(ApplicationShutdown shutdown) {
        super(shutdown, FileLocator.getFile((VirtualFile)ConfigurationLocationOf.internals(), (String)"version.settings"), (SystemConfiguration)new WerpSystemConfiguration());
    }

    protected void cleanup() {
    }

    protected LoginHandler<PlainWerpUser> createLoginHandler() {
        return new SessionAuthentificationLoginHandler((SchneideApplication)this, this::isLoginDialogShownInitially, Optional.of(Berechtigung.anmeldenAufAdminoberfl\u00e4che.getIdentifier()));
    }

    protected WerpSession createSystemSession() {
        return new DefaultWerpSession(new SystemUser(this.getApplicationBus()), new CanDoAll(), (SchneideApplication)this, (ActionManager<WerpSession, PlainWerpUser>)this.getApplicationEngine().getActionManager(), this.zeitgeber());
    }

    public void restartApplication(WerpSession session) throws IllegalAccessException {
    }

    public void shutdownApplication(WerpSession session) throws IllegalAccessException {
        this.performDefaultShutdown(session);
    }

    protected void stopResourcesBoundTo(WerpSession currentSession) {
    }

    protected abstract boolean istEchtbetrieb();

    protected abstract boolean isLoginDialogShownInitially();

    protected Clock zeitgeber() {
        return this.zeitgeber;
    }

    protected void buildPreFrameworkResources() {
        EDT.performBlocking(() -> {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Nimbus Look&Feel is not available, using default.");
            }
        });
    }
}

