/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp;

import com.schneide.base.application.AbstractApplicationEngine;
import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.SystemConfiguration;
import com.schneide.base.application.session.SessionHandler;
import com.schneide.base.application.usermanagement.DefaultUserManager;
import com.schneide.base.application.usermanagement.data.BaseUserDataHolder;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserDataHolder;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.properties.Configuration;
import com.schneide.werp.application.WerpApplicationBase;
import com.schneide.werp.domain.benutzer.WerpUserInputHandler;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUserPersister;
import com.schneide.werp.domain.benutzer.speicherung.EncryptedUserGroupPersister;
import com.schneide.werp.domain.benutzer.speicherung.UserDataEncryption;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.domain.session.WerpSessionHandler;
import java.io.IOException;

public class WerpApplicationEngine
extends AbstractApplicationEngine<WerpSession, PlainWerpUser> {
    public WerpApplicationEngine(WerpApplicationBase application, SystemConfiguration systemConfiguration, WerpSessionHandler sessionHandler) {
        super((SchneideApplication)application, systemConfiguration, (SessionHandler)sessionHandler);
    }

    protected UserManager<PlainWerpUser> buildUserManager(UserDataHolder<PlainWerpUser> currentUserDataHolder) {
        return new DefaultUserManager(currentUserDataHolder);
    }

    private EventBus applicationBus() {
        return this.getApplication().getApplicationBus();
    }

    protected UserDataHolder<PlainWerpUser> buildUserDataHolder(VirtualFile userManagementConfigurationFile, SystemConfiguration systemConfiguration) {
        BaseUserDataHolder result = new BaseUserDataHolder(new Configuration(new VirtualFile[]{userManagementConfigurationFile}), this.getMenuManager().getMenuBarSpecification(), this.getActionManager().getActionReferenceSpecification(), (AdditionalInputHandler)new WerpUserInputHandler(this.applicationBus()));
        UserDataEncryption encryption = UserDataEncryption.create();
        EncryptedUserGroupPersister userGroupHandler = new EncryptedUserGroupPersister(encryption, this.applicationBus());
        PlainWerpUserPersister userPersister = new PlainWerpUserPersister(userGroupHandler, encryption, this.applicationBus());
        try {
            userGroupHandler.load();
            userPersister.load();
        }
        catch (IOException e) {
            this.getLogger().fatal((Object)"Cannot load user information, it won't be possible to login.", (Throwable)e);
        }
        result.setSchneideUserGroupHandler((UserGroupHandler)userGroupHandler);
        result.setSchneideUserHandler((SchneideUserHandler)userPersister);
        return result;
    }
}

