/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import nl.jj.swingx.gui.modal.CloseBlocker;
import nl.jj.swingx.gui.modal.InputBlocker;
import nl.jj.swingx.gui.modal.JBusyPanel;
import nl.jj.swingx.gui.modal.JModalConfiguration;
import nl.jj.swingx.gui.modal.JModalEventQueue;
import nl.jj.swingx.gui.modal.JModalHelper;
import nl.jj.swingx.gui.utility.Utils;

public class JModalInternalFrame
extends JInternalFrame
implements InputBlocker {
    private BasicInternalFrameTitlePane titlePane;
    private JModalInternalFrame modalToOwner;
    private Vector modalToWindowsAndInputBlockers;
    private Vector blockingWindows;
    private boolean notifiedModalToWindow;
    private Component returnFocus;
    private JPanel busyPanel;
    private Color blurColor;
    private Component oldGlassPane = null;
    private boolean oldGlassPaneVisible = false;
    private int minWidth;
    private int minHeight;
    private boolean mouseCurrentlyPressed = false;
    private boolean componentIsResizedButMinSizeNotChecked = false;

    public JModalInternalFrame() {
        this("", false, false, false, false);
    }

    public JModalInternalFrame(String title) {
        this(title, false, false, false, false);
    }

    public JModalInternalFrame(String title, boolean resizable) {
        this(title, resizable, false, false, false);
    }

    public JModalInternalFrame(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false, false);
    }

    public JModalInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false);
    }

    public JModalInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this(null, null, title, resizable, closable, maximizable, iconifiable);
    }

    public JModalInternalFrame(JModalInternalFrame owner) {
        this(owner, null, "", false, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, String title) {
        this(owner, null, title, false, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, String title, boolean resizable) {
        this(owner, null, title, resizable, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, String title, boolean resizable, boolean closable) {
        this(owner, null, title, resizable, closable, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, String title, boolean resizable, boolean closable, boolean maximizable) {
        this(owner, null, title, resizable, closable, maximizable, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this(owner, null, title, resizable, closable, maximizable, iconifiable);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus) {
        this(owner, returnFocus, "", false, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus, String title) {
        this(owner, returnFocus, title, false, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus, String title, boolean resizable) {
        this(owner, returnFocus, title, resizable, false, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus, String title, boolean resizable, boolean closable) {
        this(owner, returnFocus, title, resizable, closable, false, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus, String title, boolean resizable, boolean closable, boolean maximizable) {
        this(owner, returnFocus, title, resizable, closable, maximizable, false);
    }

    public JModalInternalFrame(JModalInternalFrame owner, Component returnFocus, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.jmodalInternalFrameInit(owner, returnFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jmodalInternalFrameInit(JModalInternalFrame owner, Component returnFocus) {
        final JModalInternalFrame iframe = this;
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof BasicInternalFrameTitlePane)) continue;
            this.titlePane = (BasicInternalFrameTitlePane)components[i];
            this.titlePane.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    Utils.keepIFramePartiallyOnDesktop(iframe, iframe.titlePane, iframe.getDesktopPane(), iframe.getX(), iframe.getY());
                }
            });
        }
        JModalInternalFrame i = this;
        synchronized (i) {
            this.notifiedModalToWindow = true;
            this.modalToWindowsAndInputBlockers = new Vector();
            this.blockingWindows = new Vector();
            if (owner != null) {
                this.modalToOwner = owner;
                this.modalToWindowsAndInputBlockers.add(owner);
                this.setIconifiable(false);
            }
        }
        this.returnFocus = returnFocus;
        this.enableEvents(17L);
        Icon optionalIFrameIcon = JModalConfiguration.getOptionalIFrameIcon();
        if (optionalIFrameIcon != null) {
            this.setFrameIcon(optionalIFrameIcon);
        }
        this.initBusyPanel();
    }

    protected JModalInternalFrame getModalToOwner() {
        return this.modalToOwner;
    }

    private void initBusyPanel() {
        this.blurColor = JModalConfiguration.getBlurColor(this.getContentPane().getBackground());
        this.busyPanel = new JBusyPanel(this.blurColor, JModalConfiguration.getBlurStyle());
        this.busyPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JModalInternalFrame.this.checkActivationAllowed();
            }
        });
    }

    public void addAdditionalModalToWindow(Window window) {
        if (window != null && !this.modalToWindowsAndInputBlockers.contains(window)) {
            this.modalToWindowsAndInputBlockers.add(window);
            this.setIconifiable(false);
        }
    }

    public void addAdditionalModalToComponent(InputBlocker inputBlocker) {
        if (inputBlocker != null && !this.modalToWindowsAndInputBlockers.contains(inputBlocker)) {
            this.modalToWindowsAndInputBlockers.add(inputBlocker);
            this.setIconifiable(false);
        }
    }

    public boolean activateFirstAvailableBlockingWindow(WindowEvent windowEvent) {
        return JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, windowEvent);
    }

    public boolean isBusy() {
        return this.blockingWindows != null && this.blockingWindows.size() > 0;
    }

    public void setBusy(boolean busy, Window blockingWindow) {
        this.setBusyStatus(busy, blockingWindow);
    }

    public void setBusy(boolean busy, JModalInternalFrame blockingIFrame) {
        this.setBusyStatus(busy, blockingIFrame);
    }

    private void setBusyStatus(boolean busy, Component blockingWindowOrInternalFrame) {
        Frame owner;
        if (busy) {
            if (this.blockingWindows.size() == 0) {
                this.oldGlassPane = this.getGlassPane();
                this.oldGlassPaneVisible = this.getGlassPane().isVisible();
                this.setGlassPane(this.busyPanel);
            }
            this.getGlassPane().setVisible(true);
            if (!this.blockingWindows.contains(blockingWindowOrInternalFrame)) {
                this.blockingWindows.add(blockingWindowOrInternalFrame);
            }
            if (this.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                this.busyPanel.grabFocus();
            }
            if (this.isSelected()) {
                try {
                    this.setSelected(false);
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace(System.out);
                }
            }
        } else {
            this.blockingWindows.remove(blockingWindowOrInternalFrame);
            if (this.blockingWindows.size() == 0) {
                this.getGlassPane().setVisible(false);
                this.setGlassPane(this.oldGlassPane);
                this.getGlassPane().setVisible(this.oldGlassPaneVisible);
            }
        }
        if ((owner = (Frame)Utils.windowForComponent(this)) instanceof CloseBlocker) {
            ((CloseBlocker)((Object)owner)).setClosable(this);
        }
    }

    public void centerOfDesktop() {
        Utils.centerOfDesktop(this, this.getDesktopPane());
    }

    public void centerOfOwner() {
        Utils.centerOfOwner(this, this.getDesktopPane(), this.getModalToOwner());
    }

    public void relativeToOwnerChild(Component child) {
        Utils.relativeToOwnerChild(this, this.getDesktopPane(), this.getModalToOwner(), child);
    }

    public void setMinSize(Dimension dim) {
        this.setMinSize(dim.width, dim.height);
    }

    public void setMinSize(int width, int height) {
        this.minWidth = width;
        this.minHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        JModalInternalFrame jModalInternalFrame = this;
        synchronized (jModalInternalFrame) {
            if (this.modalToWindowsAndInputBlockers != null && this.modalToWindowsAndInputBlockers.size() > 0 && !this.notifiedModalToWindow) {
                JModalHelper.unblockWindows((Collection)this.modalToWindowsAndInputBlockers, this, this.returnFocus);
                this.notifiedModalToWindow = true;
            }
        }
    }

    public void doDefaultCloseAction() {
        if (this.isBusy()) {
            return;
        }
        if (this.getDefaultCloseOperation() == 2) {
            this.restoreOwner();
            this.release();
        }
        super.doDefaultCloseAction();
    }

    public int getDefaultCloseOperation() {
        if (this.isBusy()) {
            return 0;
        }
        return super.getDefaultCloseOperation();
    }

    public void setClosed(boolean closed) throws PropertyVetoException {
        if (closed && this.isBusy()) {
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, null);
        } else {
            this.restoreOwner();
            this.release();
            super.setClosed(closed);
        }
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        if (selected && this.isBusy()) {
            this.toFront();
            super.setSelected(false);
            this.deselectAnySelectedIFrame();
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, null);
        } else {
            Component mostRecentFocusOwner = null;
            if (selected) {
                mostRecentFocusOwner = this.getMostRecentFocusOwner();
            }
            super.setSelected(selected);
            if (this.isSelected()) {
                this.needToActivateModalToWindow();
                if (mostRecentFocusOwner != null && this.getMostRecentFocusOwner() == null) {
                    JModalHelper.setDelayedReturnFocus(mostRecentFocusOwner);
                }
            }
        }
    }

    public void setIcon(boolean iconify) throws PropertyVetoException {
        if (this.modalToWindowsAndInputBlockers != null && this.modalToWindowsAndInputBlockers.size() > 0) {
            this.setIconifiable(false);
            return;
        }
        if (iconify && this.isBusy() && !JModalConfiguration.allowIconifyForBlockedInternalFrame()) {
            return;
        }
        super.setIcon(iconify);
    }

    private void checkActivationAllowed() {
        if (this.isBusy()) {
            this.toFront();
            try {
                super.setSelected(false);
                this.deselectAnySelectedIFrame();
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace(System.out);
            }
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, null);
        }
    }

    private void deselectAnySelectedIFrame() throws PropertyVetoException {
        JInternalFrame selectedIFrame = this.getDesktopPane().getSelectedFrame();
        if (selectedIFrame != null) {
            selectedIFrame.setSelected(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void waitForClose() {
        if (EventQueue.isDispatchThread()) {
            if (!JModalConfiguration.simulateWaitOnEDT()) throw new Error("Cannot call wait from the event dispatcher thread or use JModalConfiguration.enableWaitOnEDT([JModalEventQueue]).");
            EventQueue queue = this.getToolkit().getSystemEventQueue();
            if (!(queue instanceof JModalEventQueue)) throw new Error("Cannot call wait from the event dispatcher thread due to wrong EventQueue class.");
            ((JModalEventQueue)queue).waitForClose(this);
            return;
        }
        try {
            this.wait();
            return;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.out);
        }
    }

    public final synchronized void release() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        JModalInternalFrame jModalInternalFrame = this;
        synchronized (jModalInternalFrame) {
            if (this.modalToWindowsAndInputBlockers.size() > 0 && this.notifiedModalToWindow) {
                JModalHelper.blockWindows((Collection)this.modalToWindowsAndInputBlockers, this);
                this.notifiedModalToWindow = false;
            }
        }
        super.show();
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            if (this.isBusy()) {
                this.setVisible(true);
                return;
            }
            this.restoreOwner();
            this.release();
        }
        super.setVisible(visible);
    }

    synchronized void startModal() {
        this.waitForClose();
    }

    synchronized void stopModal() {
        this.release();
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int eventId = componentEvent.getID();
        switch (eventId) {
            case 101: {
                this.componentIsResizedButMinSizeNotChecked = true;
                if (this.mouseCurrentlyPressed || this.hasAtLeastMinimumSize()) break;
                return;
            }
        }
        super.processComponentEvent(componentEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int eventId = mouseEvent.getID();
        switch (eventId) {
            case 501: {
                this.mouseCurrentlyPressed = true;
                break;
            }
            case 502: {
                this.mouseCurrentlyPressed = false;
                Utils.keepIFramePartiallyOnDesktop(this, this.titlePane, this.getDesktopPane(), this.getX(), this.getY());
                break;
            }
            case 500: {
                this.mouseCurrentlyPressed = false;
                break;
            }
            case 505: {
                break;
            }
        }
        if (!this.mouseCurrentlyPressed && this.componentIsResizedButMinSizeNotChecked) {
            this.hasAtLeastMinimumSize();
        }
        super.processMouseEvent(mouseEvent);
    }

    private boolean hasAtLeastMinimumSize() {
        this.componentIsResizedButMinSizeNotChecked = false;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.minWidth > 0 && width < this.minWidth) {
            width = this.minWidth;
        }
        if (this.minHeight > 0 && height < this.minHeight) {
            height = this.minHeight;
        }
        if (width != this.getWidth() || height != this.getHeight()) {
            this.setSize(width, height);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (!this.isClosed) {
            this.setDefaultCloseOperation(2);
            this.doDefaultCloseAction();
            return;
        }
        super.dispose();
    }

    private void needToActivateModalToWindow() {
        JModalInternalFrame modalToOwner;
        if (JModalConfiguration.keepModalToWindowInFront() && (modalToOwner = this.getModalToOwner()) != null) {
            modalToOwner.toFront();
            this.toFront();
        }
    }
}

