/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import nl.jj.swingx.gui.modal.InputBlocker;
import nl.jj.swingx.gui.modal.JModalInternalFrame;
import nl.jj.swingx.gui.modal.JModalWindow;
import nl.jj.swingx.gui.utility.Utils;

public class JModalInternalDialog
extends JModalInternalFrame {
    private Vector disabledMenuItems;

    public JModalInternalDialog(JModalInternalFrame ownerIFrame) {
        this(ownerIFrame, null, "", false, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, String title) {
        this(ownerIFrame, null, title, false, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, String title, boolean resizable) {
        this(ownerIFrame, null, title, resizable, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, String title, boolean resizable, boolean closable) {
        this(ownerIFrame, null, title, resizable, closable, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, String title, boolean resizable, boolean closable, boolean maximizable) {
        this(ownerIFrame, null, title, resizable, closable, maximizable, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this(ownerIFrame, null, title, resizable, closable, maximizable, iconifiable);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus) {
        this(ownerIFrame, returnFocus, "", false, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus, String title) {
        this(ownerIFrame, returnFocus, title, false, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus, String title, boolean resizable) {
        this(ownerIFrame, returnFocus, title, resizable, false, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus, String title, boolean resizable, boolean closable) {
        this(ownerIFrame, returnFocus, title, resizable, closable, false, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus, String title, boolean resizable, boolean closable, boolean maximizable) {
        this(ownerIFrame, returnFocus, title, resizable, closable, maximizable, false);
    }

    public JModalInternalDialog(JModalInternalFrame ownerIFrame, Component returnFocus, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.markAllInternalFrames(ownerIFrame);
        this.markAllWindows(ownerIFrame);
        this.disableMenu(ownerIFrame);
    }

    private void markAllInternalFrames(JModalInternalFrame ownerIFrame) {
        JInternalFrame[] frames = ownerIFrame.getDesktopPane().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (this.equals(frames[i]) || !(frames[i] instanceof InputBlocker)) continue;
            this.addAdditionalModalToComponent((InputBlocker)((Object)frames[i]));
        }
    }

    private void markAllWindows(JModalInternalFrame ownerIFrame) {
        Frame owner = (Frame)Utils.windowForComponent(ownerIFrame);
        Frame[] frames = owner.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            this.markWindowAndChildren(frames[i], owner);
        }
    }

    private void markWindowAndChildren(Window window, Frame excludeFrame) {
        if (window.isDisplayable()) {
            Window[] children = window.getOwnedWindows();
            for (int i = 0; i < children.length; ++i) {
                this.markWindowAndChildren(children[i], excludeFrame);
            }
            if (!(window.equals(JModalWindow.getSharedOwnerFrame()) || this.equals(window) || excludeFrame.equals(window))) {
                this.addAdditionalModalToWindow(window);
            }
        }
    }

    private void disableMenu(JModalInternalFrame ownerIFrame) {
        int i;
        Frame frame;
        Accessible menuBar;
        this.disabledMenuItems = new Vector();
        Window window = Utils.windowForComponent(ownerIFrame);
        if (window != null && window instanceof Frame && (menuBar = (frame = (Frame)window).getMenuBar()) != null) {
            for (i = 0; i < ((MenuBar)menuBar).getMenuCount(); ++i) {
                Menu menu = ((MenuBar)menuBar).getMenu(i);
                if (!menu.isEnabled()) continue;
                menu.setEnabled(false);
                this.disabledMenuItems.add(menu);
            }
        }
        if (window != null && window instanceof JFrame && (menuBar = ((JFrame)(frame = (JFrame)window)).getJMenuBar()) != null) {
            Component[] items = ((Container)((Object)menuBar)).getComponents();
            for (i = 0; i < items.length; ++i) {
                if (!items[i].isEnabled()) continue;
                items[i].setEnabled(false);
                this.disabledMenuItems.add(items[i]);
            }
        }
    }

    private void restoreMenu() {
        if (this.disabledMenuItems == null) {
            return;
        }
        Iterator menuIterator = this.disabledMenuItems.iterator();
        while (menuIterator.hasNext()) {
            Object obj = menuIterator.next();
            if (obj instanceof Component) {
                ((Component)obj).setEnabled(true);
                continue;
            }
            if (!(obj instanceof MenuItem)) continue;
            ((MenuItem)obj).setEnabled(true);
        }
    }

    public void doDefaultCloseAction() {
        if (!this.isBusy() && this.getDefaultCloseOperation() == 2) {
            this.restoreMenu();
        }
        super.doDefaultCloseAction();
    }

    public void setClosed(boolean closed) throws PropertyVetoException {
        if (!this.isBusy() && closed) {
            this.restoreMenu();
        }
        super.setClosed(closed);
    }

    public void setVisible(boolean visible) {
        if (!this.isBusy() && !visible) {
            this.restoreMenu();
        }
        super.setVisible(visible);
    }

    synchronized void stopModal() {
        this.restoreMenu();
        super.release();
    }
}

