/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import nl.jj.swingx.gui.JImagePanel;
import nl.jj.swingx.gui.modal.JModalConfiguration;
import nl.jj.swingx.gui.modal.JModalFrame;
import nl.jj.swingx.gui.utility.Utils;

public class JSplashFrame
extends JModalFrame {
    private JPanel contentPanel;
    private Point priorDragLocation;
    private Point cursorDragAnchor;
    private int windowDragBorderDistance;
    private JImagePanel jip = null;

    public JSplashFrame(Image image) {
        this.init(new JImagePanel(image));
    }

    public JSplashFrame(ImageIcon imageIcon) {
        this.init(new JImagePanel(imageIcon));
    }

    public JSplashFrame(String filename) {
        this.init(new JImagePanel(filename));
    }

    public JSplashFrame(URL url) {
        this.init(new JImagePanel(url));
    }

    private void init(JImagePanel jip) {
        this.windowDragBorderDistance = JModalConfiguration.getWindowDragBorderDistance();
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.contentPanel.setBackground(this.getBackground());
        this.contentPanel.setForeground(this.getForeground());
        this.contentPanel.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        this.setContentPane(this.contentPanel);
        this.jip = jip;
        this.getContentPane().add(jip);
        this.setUndecorated(true);
        this.setSize(jip.getImageSize());
        this.enableEvents(32L);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 503: {
                this.checkDragZone(mouseEvent);
                break;
            }
            case 506: {
                this.dragWindow(mouseEvent);
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private void checkDragZone(MouseEvent mouseEvent) {
        if (!JModalConfiguration.isWindowDraggingEnabled()) {
            return;
        }
        this.priorDragLocation = mouseEvent.getPoint();
        this.cursorDragAnchor = null;
        if (mouseEvent.getX() < this.windowDragBorderDistance || mouseEvent.getX() >= this.getWidth() - this.windowDragBorderDistance) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (mouseEvent.getY() < this.windowDragBorderDistance || mouseEvent.getY() >= this.getHeight() - this.windowDragBorderDistance) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void dragWindow(MouseEvent mouseEvent) {
        if (!JModalConfiguration.isWindowDraggingEnabled()) {
            return;
        }
        Point cursorRelativePosition = mouseEvent.getPoint();
        if (this.cursorDragAnchor == null) {
            this.cursorDragAnchor = cursorRelativePosition;
        }
        if (this.getCursor().equals(Cursor.getPredefinedCursor(13))) {
            if (this.priorDragLocation == null) {
                this.priorDragLocation = mouseEvent.getPoint();
            } else {
                int deltaX = mouseEvent.getX() - this.priorDragLocation.x;
                int deltaY = mouseEvent.getY() - this.priorDragLocation.y;
                int x = this.getX() + (deltaX += cursorRelativePosition.x - this.cursorDragAnchor.x);
                int y = this.getY() + (deltaY += cursorRelativePosition.y - this.cursorDragAnchor.y);
                if (x != this.getX() || y != this.getY()) {
                    Utils.keepWindowPartiallyOnScreen(this, x, y);
                }
                this.priorDragLocation = null;
            }
        }
    }

    public void paint(Graphics gfx) {
        gfx.draw3DRect(0, 0, this.getWidth(), this.getHeight(), false);
        super.paint(gfx);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.contentPanel != null) {
            this.contentPanel.setBackground(color);
        }
        if (this.jip != null) {
            this.jip.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.contentPanel != null) {
            this.contentPanel.setForeground(color);
        }
    }
}

