/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class JImagePanel
extends JPanel {
    public static final int MODE_WALLPAPER = 0;
    public static final int MODE_CENTER = 1;
    public static final int MODE_TILES = 2;
    public static final int MODE_FULL = 3;
    private boolean fixWidth = false;
    private boolean fixHeight = false;
    private Image image = null;
    private Image imageBuffer = null;
    private Graphics imageBufferGfx = null;
    private boolean imageLoaded = false;
    private String filename;
    private URL url;
    private boolean imageOn = true;
    private int mode = 0;

    public JImagePanel() {
    }

    public JImagePanel(Image image) {
        this.image = image;
        this.filename = null;
        this.url = null;
        this.imageLoaded = true;
    }

    public JImagePanel(Image image, boolean fixWidth, boolean fixHeight) {
        this(image);
        this.fixWidth = fixWidth;
        this.fixHeight = fixHeight;
    }

    public JImagePanel(ImageIcon imageIcon) {
        this.image = imageIcon.getImage();
        this.filename = null;
        this.url = null;
        this.imageLoaded = true;
    }

    public JImagePanel(ImageIcon imageIcon, boolean fixWidth, boolean fixHeight) {
        this(imageIcon);
        this.fixWidth = fixWidth;
        this.fixHeight = fixHeight;
    }

    public JImagePanel(String filename) {
        this(filename, false);
    }

    public JImagePanel(String filename, boolean reloadImage) {
        this.filename = filename;
        this.url = null;
        this.loadImage(reloadImage);
    }

    public JImagePanel(String filename, boolean reloadImage, boolean fixWidth, boolean fixHeight) {
        this(filename, reloadImage);
        this.fixWidth = fixWidth;
        this.fixHeight = fixHeight;
    }

    public JImagePanel(URL url) {
        this(url, false);
    }

    public JImagePanel(URL url, boolean reloadImage) {
        this.filename = null;
        this.url = url;
        this.loadImage(reloadImage);
    }

    public JImagePanel(URL url, boolean reloadImage, boolean fixWidth, boolean fixHeight) {
        this(url, reloadImage);
        this.fixWidth = fixWidth;
        this.fixHeight = fixHeight;
    }

    public void setImage(Image image) {
        this.image = image;
        this.filename = null;
        this.url = null;
        this.imageLoaded = true;
        this.repaint();
    }

    public void setImage(ImageIcon icon) {
        this.image = icon.getImage();
        this.imageLoaded = true;
        this.filename = null;
        this.url = null;
        this.repaint();
    }

    public void setImage(String filename) {
        this.setImage(filename, false);
    }

    public void setImage(String filename, boolean reloadImage) {
        this.filename = filename;
        this.url = null;
        this.loadImage(reloadImage);
    }

    public void setImage(URL url) {
        this.setImage(url, false);
    }

    public void setImage(URL url, boolean reloadImage) {
        this.filename = null;
        this.url = url;
        this.loadImage(reloadImage);
    }

    private void loadImage(boolean reloadImage) {
        MediaTracker tracker = new MediaTracker(this);
        this.imageLoaded = false;
        this.repaint();
        try {
            this.image = this.filename != null ? (reloadImage ? this.getToolkit().createImage(this.filename) : this.getToolkit().getImage(this.filename)) : (reloadImage ? this.getToolkit().createImage(this.url) : this.getToolkit().getImage(this.url));
            try {
                tracker.addImage(this.image, 0);
                tracker.waitForAll();
                this.imageLoaded = !tracker.isErrorAny();
            }
            catch (InterruptedException ie) {
                System.out.println("Loading background image " + (this.filename != null ? this.filename : this.url.toString()) + " is interrupted.");
            }
        }
        catch (Exception e) {
            System.out.println("Can't load background image: " + (this.filename != null ? this.filename : this.url.toString()));
        }
        this.repaint();
    }

    public void turnImageOff() {
        this.imageOn = false;
    }

    public void turnImageOn() {
        this.imageOn = true;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void paint(Graphics gfx) {
        if (this.imageBuffer == null) {
            this.imageBuffer = this.createImage(this.getWidth(), this.getHeight());
            this.imageBufferGfx = this.imageBuffer.getGraphics();
        }
        if (this.imageLoaded && this.imageOn) {
            this.imageBufferGfx.setColor(this.getBackground());
            this.imageBufferGfx.fillRect(0, 0, this.getWidth(), this.getHeight());
            switch (this.mode) {
                case 3: {
                    this.imageBufferGfx.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
                    break;
                }
                case 1: {
                    Rectangle panelBounds = this.getBounds();
                    int x = (int)(panelBounds.getX() + panelBounds.getWidth() / 2.0 - (double)(this.image.getWidth(this) / 2));
                    int y = (int)(panelBounds.getY() + panelBounds.getHeight() / 2.0 - (double)(this.image.getHeight(this) / 2));
                    this.imageBufferGfx.drawImage(this.image, x, y, this);
                    break;
                }
                case 2: {
                    for (int x = 0; x < this.getWidth(); x += this.image.getWidth(this)) {
                        for (int y = 0; y < this.getHeight(); y += this.image.getHeight(this)) {
                            this.imageBufferGfx.drawImage(this.image, x, y, this);
                        }
                    }
                    break;
                }
                default: {
                    this.imageBufferGfx.drawImage(this.image, 0, 0, this);
                }
            }
            gfx.drawImage(this.imageBuffer, 0, 0, this);
            if (this.getBorder() != null) {
                this.getBorder().paintBorder(this, gfx, 0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            this.imageBufferGfx.clearRect(0, 0, this.getWidth(), this.getHeight());
            gfx.drawImage(this.imageBuffer, 0, 0, this);
        }
        this.paintChildren(gfx);
    }

    public void reshape(int x, int y, int width, int height) {
        this.imageBuffer = null;
        super.reshape(x, y, width, height);
    }

    public int getWidth() {
        if (this.fixWidth) {
            return this.image.getWidth(this);
        }
        return super.getWidth();
    }

    public int getHeight() {
        if (this.fixHeight) {
            return this.image.getHeight(this);
        }
        return super.getHeight();
    }

    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (this.fixWidth) {
            dim.width = this.getWidth();
        }
        if (this.fixHeight) {
            dim.height = this.getHeight();
        }
        return dim;
    }

    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (this.fixWidth) {
            dim.width = this.getWidth();
        }
        if (this.fixHeight) {
            dim.height = this.getHeight();
        }
        return dim;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.fixWidth) {
            dim.width = this.getWidth();
        }
        if (this.fixHeight) {
            dim.height = this.getHeight();
        }
        return dim;
    }

    public Dimension getImageSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }
}

