/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json.bereiche;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.Projektnummer;
import com.schneide.werp.domain.projekt.Projektst\u00fccklisteneintrag;
import com.schneide.werp.module.datenspeicherung.json.JsonBasedPersistence;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ProjektDatenspeicherung;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonBasedProjektPersistence
extends JsonBasedPersistence
implements ProjektDatenspeicherung {
    public void speichere(Projekt projekt, VirtualFile inDatei) throws IOException {
        JsonObject result = new JsonObject();
        result.addProperty("Projektnummer", projekt.nummer().alsText());
        result.addProperty("Kunde", projekt.kunde());
        result.addProperty("Beschreibung", projekt.beschreibung());
        JsonArray kommentare = new JsonArray();
        projekt.kommentare().forEach(arg_0 -> ((JsonArray)kommentare).add(arg_0));
        result.add("Kommentare", (JsonElement)kommentare);
        JsonArray st\u00fcckliste = new JsonArray();
        projekt.st\u00fccklisteneintr\u00e4ge().forEach(each -> {
            JsonObject eintrag = new JsonObject();
            eintrag.addProperty("Position", (Number)each.position());
            eintrag.addProperty("Anzahl", (Number)each.anzahl());
            eintrag.addProperty("Artikelnummer", each.artikelreferenz().artikelnummer().alsText());
            eintrag.addProperty("Revision", (Number)each.artikelreferenz().revision().alsInteger());
            st\u00fcckliste.add((JsonElement)eintrag);
        });
        result.add("St\u00fcckliste", (JsonElement)st\u00fcckliste);
        this.schreibe((JsonElement)result, inDatei);
    }

    public Optional<Projekt> ladeAus(VirtualFile datei, ArtikelRepository artikel) throws IOException {
        this.getLogger().debug((Object)("Lade Projekt aus " + String.valueOf(datei)));
        try (JsonReader reader = new JsonReader(datei.getReader());){
            Map data = (Map)this.json().fromJson(reader, HashMap.class);
            String projektnummer = this.stringFrom(data, "Projektnummer");
            String kunde = this.stringFrom(data, "Kunde");
            String beschreibung = this.stringFrom(data, "Beschreibung");
            List<String> kommentare = this.stringsFrom(data, "Kommentare");
            Iterable<Projektst\u00fccklisteneintrag> projektst\u00fcckliste = this.st\u00fccklisteAus(this.objectListFrom(data, "St\u00fcckliste"), artikel);
            Projekt result = new Projekt(new Projektnummer(projektnummer), kunde, beschreibung, kommentare, projektst\u00fcckliste);
            Optional<Projekt> optional = Optional.of(result);
            return optional;
        }
    }

    private Iterable<Projektst\u00fccklisteneintrag> st\u00fccklisteAus(List<Map<String, Object>> eintr\u00e4ge, ArtikelRepository artikel) {
        ArrayList<Projektst\u00fccklisteneintrag> result = new ArrayList<Projektst\u00fccklisteneintrag>();
        eintr\u00e4ge.forEach(each -> {
            Artikelreferenz referenz = new Artikelreferenz(new Artikelnummer(this.stringFrom((Map<String, Object>)each, "Artikelnummer")), new Artikelrevision(this.integerFrom((Map<String, Object>)each, "Revision")));
            Optional maybeArtikel = artikel.f\u00fcrReferenz(referenz);
            if (maybeArtikel.isEmpty()) {
                return;
            }
            Projektst\u00fccklisteneintrag eintrag = new Projektst\u00fccklisteneintrag(this.integerFrom((Map<String, Object>)each, "Position"), this.integerFrom((Map<String, Object>)each, "Anzahl"), (Artikel)maybeArtikel.get());
            result.add(eintrag);
        });
        return result;
    }
}

