/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json.bereiche;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.module.datenspeicherung.json.domain.JsonPersistence;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ProduktionsartikelDatenspeicherung;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JsonBasedProduktionsartikelPersistence
extends JsonPersistence
implements ProduktionsartikelDatenspeicherung {
    public void speichere(Produktionsartikel artikel, VirtualFile inDatei) throws IOException {
        JsonObject result = new JsonObject();
        result.add("Listenkoordinate", (JsonElement)this.jsonify(artikel.koordinate()));
        result.addProperty("Artikel", artikel.artikel().revisionierteArtikelnummer());
        result.add("Eigenschaften", (JsonElement)this.jsonify(artikel.eigenschaften()));
        this.schreibe((JsonElement)result, inDatei);
    }

    public Optional<Produktionsartikel> ladeAus(VirtualFile datei, ArtikelRepository alleArtikel) throws IOException {
        try (JsonReader reader = new JsonReader(datei.getReader());){
            Map data = (Map)this.json().fromJson(reader, HashMap.class);
            Optional<Produktionskoordinate> maybeKoordinate = this.dejsonifyProduktionskoordinate(this.objectFrom(data, "Listenkoordinate"));
            if (maybeKoordinate.isEmpty()) {
                this.getLogger().error((Object)"Kann eine Listenkoordinate nicht parsen.");
                Optional<Produktionsartikel> optional = Optional.empty();
                return optional;
            }
            String artikelreferenz = this.stringFrom(data, "Artikel");
            Optional maybeArtikel = alleArtikel.f\u00fcrRevisionierteArtikelnummer(artikelreferenz);
            if (maybeArtikel.isEmpty()) {
                this.getLogger().error((Object)("Kann den Artikel " + artikelreferenz + " nicht aufl\u00f6sen."));
                Optional<Produktionsartikel> optional = Optional.empty();
                return optional;
            }
            Map<String, Object> roheigenschaften = this.objectFrom(data, "Eigenschaften");
            Produktionsartikel result = new Produktionsartikel(maybeKoordinate.get(), (Artikel)maybeArtikel.get());
            for (Map.Entry<String, Object> each : roheigenschaften.entrySet()) {
                result = result.mitEigenschaftF\u00fcr(each.getKey(), String.valueOf(each.getValue()));
            }
            Optional<Produktionsartikel> optional = Optional.of(result);
            return optional;
        }
    }
}

