/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json.bereiche;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.module.datenspeicherung.json.JsonBasedPersistence;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ArtikelDatenspeicherung;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonBasedArtikelPersistence
extends JsonBasedPersistence
implements ArtikelDatenspeicherung {
    public Optional<Artikel<?>> ladeAus(VirtualFile datei, ArbeitsschrittRepository arbeitsschritte) throws IOException {
        try (JsonReader reader = new JsonReader(datei.getReader());){
            Map data = (Map)this.json().fromJson(reader, HashMap.class);
            boolean istBaugruppe = (Boolean)data.get("Baugruppe");
            String artikelnummer = this.stringFrom(data, "Artikelnummer");
            int revision = this.integerFrom(data, "Revision");
            String benennung = this.stringFrom(data, "Benennung");
            String erf\u00fcllungsweg = this.stringFrom(data, "Erf\u00fcllungsweg");
            Map<String, Object> eigenschaften = this.objectFrom(data, "Eigenschaften");
            Artikelerstellung erstellung = istBaugruppe ? new Baugruppenerstellung() : new Einzelteilerstellung();
            Object result = erstellung.erstelleF\u00fcr(artikelnummer, benennung, revision, erf\u00fcllungsweg, eigenschaften);
            result.alsBaugruppe().ifPresent(baugruppe -> {
                List<Map<String, Object>> st\u00fccklisteneintr\u00e4ge = this.objectListFrom(data, "St\u00fcckliste");
                for (Map<String, Object> each : st\u00fccklisteneintr\u00e4ge) {
                    baugruppe.f\u00fcgeInSt\u00fccklisteEin(this.integerFrom(each, "Position"), this.integerFrom(each, "Anzahl"), new Artikelreferenz(new Artikelnummer(this.stringFrom(each, "Artikelnummer")), new Artikelrevision(this.integerFrom(each, "Revision"))));
                }
            });
            Optional<Artikel<?>> optional = Optional.of(result);
            return optional;
        }
    }

    public void speichere(Artikel<?> artikel, VirtualFile inDatei) throws IOException {
        this.getLogger().info((Object)("Speichere " + String.valueOf(artikel) + " in " + String.valueOf(inDatei) + " als " + (artikel.istBaugruppe() ? "Baugruppe" : "Einzelteil")));
        JsonObject result = new JsonObject();
        result.addProperty("Artikelnummer", artikel.artikelnummer().alsText());
        result.addProperty("Revision", (Number)artikel.revision().alsInteger());
        result.addProperty("Benennung", artikel.benennung());
        result.addProperty("Baugruppe", Boolean.valueOf(artikel.istBaugruppe()));
        result.addProperty("Erf\u00fcllungsweg", artikel.erf\u00fcllungsweg());
        JsonObject eigenschaften = new JsonObject();
        result.add("Eigenschaften", (JsonElement)eigenschaften);
        artikel.alleEigenschaften().forEach((key, value) -> eigenschaften.addProperty(key, value));
        JsonArray st\u00fcckliste = new JsonArray();
        Iterable eintr\u00e4ge = artikel.st\u00fccklisteneintr\u00e4ge();
        for (St\u00fccklisteneintrag each : eintr\u00e4ge) {
            JsonObject eintrag = new JsonObject();
            eintrag.addProperty("Position", (Number)each.position());
            eintrag.addProperty("Anzahl", (Number)each.anzahl());
            eintrag.addProperty("Artikelnummer", each.artikelreferenz().artikelnummer().alsText());
            eintrag.addProperty("Revision", (Number)each.artikelreferenz().revision().alsInteger());
            st\u00fcckliste.add((JsonElement)eintrag);
        }
        result.add("St\u00fcckliste", (JsonElement)st\u00fcckliste);
        this.schreibe((JsonElement)result, inDatei);
    }

    private static class Baugruppenerstellung
    extends Artikelerstellung<Baugruppe> {
        private Baugruppenerstellung() {
        }

        @Override
        public Baugruppe erstelleOhneEigenschaftenF\u00fcr(String artikelnummer, String benennung, int revision, String erf\u00fcllungsweg) {
            return new Baugruppe(new Artikelnummer(artikelnummer), benennung, new Artikelrevision(revision), erf\u00fcllungsweg);
        }
    }

    private static class Einzelteilerstellung
    extends Artikelerstellung<Einzelteil> {
        private Einzelteilerstellung() {
        }

        @Override
        protected Einzelteil erstelleOhneEigenschaftenF\u00fcr(String artikelnummer, String benennung, int revision, String erf\u00fcllungsweg) {
            return new Einzelteil(new Artikelnummer(artikelnummer), benennung, new Artikelrevision(revision), erf\u00fcllungsweg);
        }
    }

    private static abstract class Artikelerstellung<A extends Artikel<A>> {
        private Artikelerstellung() {
        }

        public final A erstelleF\u00fcr(String artikelnummer, String benennung, int revision, String erf\u00fcllungsweg, Map<String, Object> eigenschaften) {
            Object result = this.erstelleOhneEigenschaftenF\u00fcr(artikelnummer, benennung, revision, erf\u00fcllungsweg);
            for (Map.Entry<String, Object> each : eigenschaften.entrySet()) {
                result = result.mitEigenschaftF\u00fcr(each.getKey(), String.valueOf(each.getValue()));
            }
            return result;
        }

        protected abstract A erstelleOhneEigenschaftenF\u00fcr(String var1, String var2, int var3, String var4);
    }
}

