/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.writer.WriteTo;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class JsonBasedPersistence
extends LoggedObject {
    private final Gson jsonDriver = new GsonBuilder().setPrettyPrinting().create();

    public String dateiendung() {
        return ".json";
    }

    protected JsonObject jsonObjectFrom(Map<String, Object> data, String eintrag) {
        return (JsonObject)data.get(eintrag);
    }

    protected int integerFrom(Map<String, Object> data, String eintrag) {
        return (int)Math.round((Double)data.get(eintrag));
    }

    protected List<Integer> integersFrom(Map<String, Object> data, String eintrag) {
        List unrounded = (List)data.get(eintrag);
        return unrounded.stream().map(Math::round).map(Long::intValue).collect(Collectors.toList());
    }

    protected String stringFrom(Map<String, Object> data, String eintrag) {
        return (String)data.get(eintrag);
    }

    protected boolean booleanFrom(Map<String, Object> data, String eintrag) {
        return (Boolean)data.get(eintrag);
    }

    protected List<String> stringsFrom(Map<String, Object> data, String eintrag) {
        return (List)data.get(eintrag);
    }

    protected Map<String, Object> objectFrom(Map<String, Object> data, String eintrag) {
        return (Map)data.get(eintrag);
    }

    protected List<Map<String, Object>> objectListFrom(Map<String, Object> data, String eintrag) {
        return (List)data.get(eintrag);
    }

    protected JsonObject jsonify(Map<String, String> data) {
        JsonObject result = new JsonObject();
        data.forEach((k, v) -> result.addProperty(k, v));
        return result;
    }

    protected <A> JsonArray objectArray(Iterable<A> list, Function<A, JsonElement> conversion) {
        return this.objectArray((Iterable<? extends JsonElement>)new TransformingIterable(conversion, list));
    }

    protected JsonArray objectArray(Iterable<? extends JsonElement> list) {
        JsonArray result = new JsonArray();
        list.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    protected <A> JsonArray stringArray(Iterable<A> list, Function<A, String> conversion) {
        return this.stringArray((Iterable<? extends String>)new TransformingIterable(conversion, list));
    }

    protected JsonArray stringArray(Iterable<? extends String> list) {
        JsonArray result = new JsonArray();
        list.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    protected JsonArray numberArray(Iterable<? extends Number> list) {
        JsonArray result = new JsonArray();
        list.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    protected void schreibe(final JsonElement data, VirtualFile inDatei) throws IOException {
        inDatei.createAsFile();
        WriteTo.virtualFile((VirtualFile)inDatei).using(new WriteTo.Writing(){

            public void writeTo(PrintWriter writer) throws IOException {
                JsonBasedPersistence.this.json().toJson(data, (Appendable)writer);
            }
        });
    }

    protected Gson json() {
        return this.jsonDriver;
    }
}

