/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.embedded.types;

import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTransfer;
import org.eclipse.serializer.persistence.types.PersistenceTarget;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageRequestAcceptor;
import org.eclipse.store.storage.types.StorageWriteController;

public interface EmbeddedStorageBinaryTarget
extends PersistenceTarget<Binary> {
    public void write(Binary var1) throws PersistenceExceptionTransfer;

    public static EmbeddedStorageBinaryTarget New(StorageRequestAcceptor requestAcceptor, StorageWriteController writeController) {
        return new Default((StorageRequestAcceptor)X.notNull((Object)requestAcceptor), (StorageWriteController)X.notNull((Object)writeController));
    }

    public static final class Default
    implements EmbeddedStorageBinaryTarget {
        private final StorageRequestAcceptor requestAcceptor;
        private final StorageWriteController writeController;

        Default(StorageRequestAcceptor requestAcceptor, StorageWriteController writeController) {
            this.requestAcceptor = requestAcceptor;
            this.writeController = writeController;
        }

        @Override
        public final void write(Binary data) throws PersistenceExceptionTransfer {
            try {
                this.writeController.validateIsWritable();
                this.requestAcceptor.storeData(data);
            }
            catch (Exception e) {
                throw new PersistenceExceptionTransfer((Throwable)e);
            }
        }

        public final void validateIsWritable() {
            this.writeController.validateIsWritable();
        }

        public final boolean isWritable() {
            return this.writeController.isWritable();
        }

        public final void validateIsStoringEnabled() {
            this.writeController.validateIsStoringEnabled();
        }

        public final boolean isStoringEnabled() {
            return this.writeController.isStoringEnabled();
        }
    }
}

