/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.util;

import org.eclipse.serializer.afs.types.AFS;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.concurrency.XThreads;
import org.eclipse.serializer.io.XIO;
import org.eclipse.store.afs.nio.types.NioFileSystem;
import org.eclipse.store.storage.types.StorageTransactionsAnalysis;

public class MainUtilTransactionFileConverter {
    public static void main(String[] args) {
        AFile file;
        if (XArrays.hasNoContent((Object[])args)) {
            System.out.println("No transaction file specified. Exiting.");
            XThreads.sleep((long)1000L);
            System.exit(-1);
        }
        if (!(file = NioFileSystem.New().ensureFile((Object)XIO.Path((String)args[0]))).exists()) {
            System.out.println("File not found: " + args[0]);
            XThreads.sleep((long)1000L);
            System.exit(-2);
        }
        System.out.println("Converting transaction entries ...");
        VarString vs = VarString.New((String)file.toString()).lf();
        StorageTransactionsAnalysis.EntryAssembler.assembleHeader(vs, "\t").lf();
        VarString s = StorageTransactionsAnalysis.Logic.parseFile(file, vs).lf().lf();
        String result = s.toString();
        System.out.println("Converted String length: " + result.length());
        AFile outputFile = file.parent().ensureFile(file.name(), "txt");
        outputFile.ensureExists();
        System.out.println("Writing File " + outputFile);
        try {
            AFS.writeString((AFile)outputFile, (String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            XThreads.sleep((long)1000L);
            System.exit(-3);
        }
        System.out.println("Done.");
        XThreads.sleep((long)1000L);
        System.exit(0);
    }
}

