/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.serializer.meta.XDebug;
import org.eclipse.serializer.monitoring.MonitoringManager;
import org.eclipse.serializer.persistence.types.ObjectIdsSelector;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceLiveStorerRegistry;
import org.eclipse.serializer.persistence.types.Unpersistable;
import org.eclipse.serializer.reference.Referencing;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.exceptions.StorageExceptionInitialization;
import org.eclipse.store.storage.exceptions.StorageExceptionNotAcceptingTasks;
import org.eclipse.store.storage.exceptions.StorageExceptionNotRunning;
import org.eclipse.store.storage.types.StorageActivePart;
import org.eclipse.store.storage.types.StorageBackupHandler;
import org.eclipse.store.storage.types.StorageBackupSetup;
import org.eclipse.store.storage.types.StorageChannel;
import org.eclipse.store.storage.types.StorageChannelCountProvider;
import org.eclipse.store.storage.types.StorageChannelTaskInitialize;
import org.eclipse.store.storage.types.StorageChannelTaskShutdown;
import org.eclipse.store.storage.types.StorageChannelsCreator;
import org.eclipse.store.storage.types.StorageConfiguration;
import org.eclipse.store.storage.types.StorageController;
import org.eclipse.store.storage.types.StorageDataChunkValidator;
import org.eclipse.store.storage.types.StorageDataFileEvaluator;
import org.eclipse.store.storage.types.StorageDataFileValidator;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageEntityMarkMonitor;
import org.eclipse.store.storage.types.StorageEventLogger;
import org.eclipse.store.storage.types.StorageExceptionHandler;
import org.eclipse.store.storage.types.StorageFileWriter;
import org.eclipse.store.storage.types.StorageGCZombieOidHandler;
import org.eclipse.store.storage.types.StorageHousekeepingBroker;
import org.eclipse.store.storage.types.StorageHousekeepingController;
import org.eclipse.store.storage.types.StorageIdAnalysis;
import org.eclipse.store.storage.types.StorageInitialDataFileNumberProvider;
import org.eclipse.store.storage.types.StorageKillable;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageLockFileManager;
import org.eclipse.store.storage.types.StorageLockFileSetup;
import org.eclipse.store.storage.types.StorageObjectIdMarkQueue;
import org.eclipse.store.storage.types.StorageObjectIdRangeEvaluator;
import org.eclipse.store.storage.types.StorageOperationController;
import org.eclipse.store.storage.types.StorageRequestAcceptor;
import org.eclipse.store.storage.types.StorageRequestTaskCreator;
import org.eclipse.store.storage.types.StorageRootOidSelector;
import org.eclipse.store.storage.types.StorageRootTypeIdProvider;
import org.eclipse.store.storage.types.StorageStructureValidator;
import org.eclipse.store.storage.types.StorageTaskBroker;
import org.eclipse.store.storage.types.StorageThreadProvider;
import org.eclipse.store.storage.types.StorageTimestampProvider;
import org.eclipse.store.storage.types.StorageTypeDictionary;
import org.eclipse.store.storage.types.StorageWriteController;
import org.slf4j.Logger;

public interface StorageSystem
extends StorageController {
    public StorageRequestAcceptor createRequestAcceptor();

    public StorageTypeDictionary typeDictionary();

    public StorageOperationController operationController();

    default public StorageChannelCountProvider channelCountProvider() {
        return this.operationController().channelCountProvider();
    }

    public StorageConfiguration configuration();

    default public AFileSystem fileSystem() {
        return this.configuration().fileProvider().fileSystem();
    }

    @Override
    public StorageSystem start();

    public StorageIdAnalysis initializationIdAnalysis();

    @Override
    public boolean shutdown();

    public StorageObjectIdRangeEvaluator objectIdRangeEvaluator();

    public static final class Default
    implements StorageSystem,
    Unpersistable,
    StorageKillable {
        private static final Logger logger = Logging.getLogger(StorageSystem.class);
        private final StorageConfiguration configuration;
        private final StorageInitialDataFileNumberProvider initialDataFileNumberProvider;
        private final StorageDataFileEvaluator fileDissolver;
        private final StorageLiveFileProvider fileProvider;
        private final StorageWriteController writeController;
        private final StorageFileWriter.Provider writerProvider;
        private final StorageRequestAcceptor.Creator requestAcceptorCreator;
        private final StorageTaskBroker.Creator taskBrokerCreator;
        private final StorageDataChunkValidator.Provider dataChunkValidatorProvider;
        private final StorageChannelsCreator channelCreator;
        private final StorageThreadProvider threadProvider;
        private final StorageEntityCacheEvaluator entityCacheEvaluator;
        private final StorageRequestTaskCreator requestTaskCreator;
        private final StorageTypeDictionary typeDictionary;
        private final StorageOperationController operationController;
        private final StorageRootTypeIdProvider rootTypeIdProvider;
        private final StorageExceptionHandler exceptionHandler;
        private final StorageHousekeepingController housekeepingController;
        private final StorageHousekeepingBroker housekeepingBroker;
        private final StorageTimestampProvider timestampProvider;
        private final StorageObjectIdRangeEvaluator objectIdRangeEvaluator;
        private final StorageGCZombieOidHandler zombieOidHandler;
        private final StorageRootOidSelector.Provider rootOidSelectorProvider;
        private final StorageObjectIdMarkQueue.Creator oidMarkQueueCreator;
        private final StorageEntityMarkMonitor.Creator entityMarkMonitorCreator;
        private final StorageDataFileValidator.Creator backupDataFileValidatorCreator;
        private final StorageBackupSetup backupSetup;
        private final StorageLockFileSetup lockFileSetup;
        private final StorageLockFileManager.Creator lockFileManagerCreator;
        private final StorageEventLogger eventLogger;
        private final ObjectIdsSelector liveObjectIdChecker;
        private final Referencing<PersistenceLiveStorerRegistry> refStorerRegistry;
        private final boolean switchByteOrder;
        private final StorageStructureValidator storageStructureValidator;
        private final MonitoringManager monitorManager;
        private final AtomicBoolean isStartingUp = new AtomicBoolean();
        private final AtomicBoolean isShuttingDown = new AtomicBoolean();
        private final Object stateLock = new Object();
        private final AtomicLong initializationTime = new AtomicLong();
        private final AtomicLong operationModeTime = new AtomicLong();
        private volatile StorageTaskBroker taskbroker;
        private final ChannelKeeper[] channelKeepers;
        private StorageBackupHandler backupHandler;
        private Thread backupThread;
        private Thread lockFileManagerThread;
        private StorageIdAnalysis initializationIdAnalysis;

        public Default(StorageConfiguration storageConfiguration, StorageOperationController.Creator ocCreator, StorageDataFileValidator.Creator backupDataFileValidatorCreator, StorageWriteController writeController, StorageHousekeepingBroker housekeepingBroker, StorageFileWriter.Provider writerProvider, StorageInitialDataFileNumberProvider initialDataFileNumberProvider, StorageRequestAcceptor.Creator requestAcceptorCreator, StorageTaskBroker.Creator taskBrokerCreator, StorageDataChunkValidator.Provider dataChunkValidatorProvider, StorageChannelsCreator channelCreator, StorageThreadProvider threadProvider, StorageRequestTaskCreator requestTaskCreator, StorageTypeDictionary typeDictionary, StorageRootTypeIdProvider rootTypeIdProvider, StorageTimestampProvider timestampProvider, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, StorageGCZombieOidHandler zombieOidHandler, StorageRootOidSelector.Provider rootOidSelectorProvider, StorageObjectIdMarkQueue.Creator oidMarkQueueCreator, StorageEntityMarkMonitor.Creator entityMarkMonitorCreator, boolean switchByteOrder, StorageLockFileSetup lockFileSetup, StorageLockFileManager.Creator lockFileManagerCreator, StorageExceptionHandler exceptionHandler, StorageEventLogger eventLogger, ObjectIdsSelector liveObjectIdChecker, Referencing<PersistenceLiveStorerRegistry> refStorerRegistry, StorageStructureValidator storageStructureValidator, MonitoringManager monitorManager) {
            StorageChannelCountProvider ccp = storageConfiguration.channelCountProvider();
            int channelCount = ccp.getChannelCount();
            StorageChannelCountProvider.validateChannelCount(channelCount);
            this.channelKeepers = new ChannelKeeper[channelCount];
            this.configuration = (StorageConfiguration)X.notNull((Object)storageConfiguration);
            this.operationController = (StorageOperationController)X.notNull((Object)ocCreator.createOperationController(ccp, this));
            this.initialDataFileNumberProvider = (StorageInitialDataFileNumberProvider)X.notNull((Object)initialDataFileNumberProvider);
            this.fileDissolver = storageConfiguration.dataFileEvaluator();
            this.fileProvider = storageConfiguration.fileProvider();
            this.entityCacheEvaluator = storageConfiguration.entityCacheEvaluator();
            this.housekeepingController = storageConfiguration.housekeepingController();
            this.housekeepingBroker = (StorageHousekeepingBroker)X.notNull((Object)housekeepingBroker);
            this.requestAcceptorCreator = (StorageRequestAcceptor.Creator)X.notNull((Object)requestAcceptorCreator);
            this.taskBrokerCreator = (StorageTaskBroker.Creator)X.notNull((Object)taskBrokerCreator);
            this.dataChunkValidatorProvider = (StorageDataChunkValidator.Provider)X.notNull((Object)dataChunkValidatorProvider);
            this.channelCreator = (StorageChannelsCreator)X.notNull((Object)channelCreator);
            this.threadProvider = (StorageThreadProvider)X.notNull((Object)threadProvider);
            this.requestTaskCreator = (StorageRequestTaskCreator)X.notNull((Object)requestTaskCreator);
            this.typeDictionary = (StorageTypeDictionary)X.notNull((Object)typeDictionary);
            this.rootTypeIdProvider = (StorageRootTypeIdProvider)X.notNull((Object)rootTypeIdProvider);
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
            this.objectIdRangeEvaluator = (StorageObjectIdRangeEvaluator)X.notNull((Object)objectIdRangeEvaluator);
            this.writeController = (StorageWriteController)X.notNull((Object)writeController);
            this.writerProvider = (StorageFileWriter.Provider)X.notNull((Object)writerProvider);
            this.zombieOidHandler = (StorageGCZombieOidHandler)X.notNull((Object)zombieOidHandler);
            this.rootOidSelectorProvider = (StorageRootOidSelector.Provider)X.notNull((Object)rootOidSelectorProvider);
            this.oidMarkQueueCreator = (StorageObjectIdMarkQueue.Creator)X.notNull((Object)oidMarkQueueCreator);
            this.entityMarkMonitorCreator = (StorageEntityMarkMonitor.Creator)X.notNull((Object)entityMarkMonitorCreator);
            this.exceptionHandler = (StorageExceptionHandler)X.notNull((Object)exceptionHandler);
            this.lockFileSetup = (StorageLockFileSetup)X.mayNull((Object)lockFileSetup);
            this.lockFileManagerCreator = (StorageLockFileManager.Creator)X.notNull((Object)lockFileManagerCreator);
            this.backupSetup = (StorageBackupSetup)X.mayNull((Object)storageConfiguration.backupSetup());
            this.backupDataFileValidatorCreator = (StorageDataFileValidator.Creator)X.notNull((Object)backupDataFileValidatorCreator);
            this.eventLogger = (StorageEventLogger)X.notNull((Object)eventLogger);
            this.liveObjectIdChecker = (ObjectIdsSelector)X.notNull((Object)liveObjectIdChecker);
            this.refStorerRegistry = (Referencing)X.notNull(refStorerRegistry);
            this.switchByteOrder = switchByteOrder;
            this.storageStructureValidator = (StorageStructureValidator)X.notNull((Object)storageStructureValidator);
            this.monitorManager = (MonitoringManager)X.notNull((Object)monitorManager);
        }

        @Override
        public final StorageConfiguration configuration() {
            return this.configuration;
        }

        @Override
        public final boolean isRunning() {
            return this.isChannelProcessingEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isActive() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.isRunning() || this.hasActiveChannels() || this.backupHandler != null && this.backupHandler.isActive();
            }
        }

        private boolean hasActiveChannels() {
            for (ChannelKeeper keeper : this.channelKeepers) {
                if (!keeper.isActive()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isChannelProcessingEnabled() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.operationController.isChannelProcessingEnabled();
                {
                }
            }
        }

        @Override
        public final boolean isAcceptingTasks() {
            return this.isChannelProcessingEnabled();
        }

        @Override
        public final boolean isStartingUp() {
            return this.isStartingUp.get();
        }

        @Override
        public final boolean isShuttingDown() {
            return this.isShuttingDown.get();
        }

        @Override
        public final long initializationTime() {
            return this.initializationTime.get();
        }

        @Override
        public final long operationModeTime() {
            return this.operationModeTime.get();
        }

        private void ensureRunning() {
            if (this.isRunning()) {
                return;
            }
            throw new StorageExceptionNotRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StorageIdAnalysis startThreads(StorageChannelTaskInitialize initializingTask) throws InterruptedException {
            StorageChannelTaskInitialize storageChannelTaskInitialize = initializingTask;
            synchronized (storageChannelTaskInitialize) {
                for (ChannelKeeper keeper : this.channelKeepers) {
                    keeper.channelThread.start();
                }
                initializingTask.waitOnCompletion();
            }
            this.timestampProvider.set(initializingTask.latestTimestamp());
            return initializingTask.idAnalysis();
        }

        private StorageBackupHandler provideBackupHandler() {
            if (this.backupHandler == null && this.backupSetup != null) {
                this.backupHandler = this.backupSetup.setupHandler(this.operationController, this.writeController, this.backupDataFileValidatorCreator, this.typeDictionary());
            }
            return this.backupHandler;
        }

        private void startBackupThread() {
            StorageBackupHandler backupHandler = this.provideBackupHandler();
            if (backupHandler == null) {
                return;
            }
            if (!this.writeController.isBackupEnabled()) {
                return;
            }
            backupHandler.start();
            this.backupThread = this.threadProvider.provideBackupThread(backupHandler);
            this.backupThread.start();
        }

        private void initializeLockFileManager() {
            if (this.lockFileSetup == null || this.lockFileSetup.updateInterval() == 0L) {
                return;
            }
            StorageLockFileManager lockFileManager = this.lockFileManagerCreator.createLockFileManager(this.lockFileSetup, this.operationController);
            lockFileManager.start();
            this.lockFileManagerThread = this.threadProvider.provideLockFileManagerThread(lockFileManager);
        }

        private void startLockFileManagerThread() {
            if (this.lockFileManagerThread == null) {
                return;
            }
            this.lockFileManagerThread.start();
        }

        private void createChannels() {
            StorageFileWriter.Provider effectiveWriterProvider = this.dispatchWriterProvider();
            StorageChannel[] channels = this.channelCreator.createChannels(this.channelCount(), this.initialDataFileNumberProvider, this.exceptionHandler, this.fileDissolver, this.fileProvider, this.entityCacheEvaluator, this.typeDictionary, this.taskbroker, this.operationController, this.housekeepingBroker, this.housekeepingController, this.timestampProvider, this.writeController, effectiveWriterProvider, this.zombieOidHandler, this.rootOidSelectorProvider, this.oidMarkQueueCreator, this.entityMarkMonitorCreator, this.provideBackupHandler(), this.eventLogger, this.liveObjectIdChecker, this.refStorerRegistry, this.switchByteOrder, this.rootTypeIdProvider.provideRootTypeId(), this.monitorManager);
            ChannelKeeper[] keepers = this.channelKeepers;
            for (int i = 0; i < channels.length; ++i) {
                keepers[i] = new ChannelKeeper(i, channels[i], this.threadProvider.provideChannelThread(channels[i]));
            }
        }

        private StorageFileWriter.Provider dispatchWriterProvider() {
            if (this.backupSetup == null) {
                return this.writerProvider;
            }
            return this.backupSetup.setupWriterProvider(this.writerProvider);
        }

        private int channelCount() {
            return this.channelKeepers.length;
        }

        private void internalStartUp() throws InterruptedException {
            this.initializeLockFileManager();
            this.storageStructureValidator.validate();
            this.taskbroker = this.taskBrokerCreator.createTaskBroker(this, this.requestTaskCreator);
            StorageChannelTaskInitialize task = this.taskbroker.issueChannelInitialization(this.operationController);
            this.createChannels();
            StorageIdAnalysis idAnalysis = this.startThreads(task);
            Long maxOid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.OID);
            this.objectIdRangeEvaluator.evaluateObjectIdRange(0L, maxOid == null ? 0L : maxOid);
            this.initializationIdAnalysis = idAnalysis;
            this.startLockFileManagerThread();
            this.startBackupThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalShutdown() throws InterruptedException {
            StorageChannelTaskShutdown task;
            if (this.taskbroker == null) {
                XDebug.println((String)"taskbroker is null");
                return;
            }
            StorageChannelTaskShutdown storageChannelTaskShutdown = task = this.taskbroker.issueChannelShutdown(this.operationController);
            synchronized (storageChannelTaskShutdown) {
                task.waitOnCompletion();
            }
            this.taskbroker = null;
            this.shutdownBackup();
            this.operationController.deactivate();
            this.monitorManager.shutdown();
        }

        @Override
        public final void checkAcceptingTasks() {
            if (this.isAcceptingTasks()) {
                return;
            }
            throw new StorageExceptionNotAcceptingTasks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Default start() {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.isRunning()) {
                    throw new StorageExceptionInitialization("already starting");
                }
                logger.info("Starting storage system");
                this.isStartingUp.set(true);
                try {
                    this.initializationTime.set(System.currentTimeMillis());
                    this.internalStartUp();
                    this.operationModeTime.set(System.currentTimeMillis());
                }
                catch (InterruptedException e) {
                    this.operationController.deactivate();
                    this.monitorManager.shutdown();
                    throw new StorageExceptionInitialization(e);
                }
                catch (Throwable t) {
                    this.operationController.deactivate();
                    this.monitorManager.shutdown();
                    throw t;
                }
                finally {
                    this.isStartingUp.set(false);
                }
            }
            return this;
        }

        @Override
        public final StorageIdAnalysis initializationIdAnalysis() {
            return this.initializationIdAnalysis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean shutdown() {
            logger.info("Stopping storage system");
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.internalShutdown();
                    logger.info("Storage system stopped");
                    return true;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }

        @Override
        public final StorageTypeDictionary typeDictionary() {
            return this.typeDictionary;
        }

        @Override
        public StorageOperationController operationController() {
            return this.operationController;
        }

        @Override
        public StorageObjectIdRangeEvaluator objectIdRangeEvaluator() {
            return this.objectIdRangeEvaluator;
        }

        @Override
        public final StorageRequestAcceptor createRequestAcceptor() {
            this.ensureRunning();
            return this.requestAcceptorCreator.createRequestAcceptor(this.dataChunkValidatorProvider.provideDataChunkValidator(this.typeDictionary), this.taskbroker);
        }

        @Override
        public void killStorage(Throwable cause) {
            this.operationController.deactivate();
            if (this.backupHandler != null) {
                this.backupHandler.setRunning(false);
            }
        }

        private void shutdownBackup() throws InterruptedException {
            if (this.backupHandler != null) {
                this.backupHandler.stop();
                this.backupThread.join();
            }
        }

        static final class ChannelKeeper
        implements StorageActivePart {
            final int channelIndex;
            final StorageChannel channel;
            final Thread channelThread;

            ChannelKeeper(int channelIndex, StorageChannel channel, Thread thread) {
                this.channelIndex = channelIndex;
                this.channel = channel;
                this.channelThread = thread;
            }

            @Override
            public final boolean isActive() {
                return this.channel.isActive();
            }
        }
    }
}

