/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.function.Consumer;
import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.exceptions.StorageExceptionStructureValidation;
import org.eclipse.store.storage.types.StorageChannelCountProvider;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.slf4j.Logger;

public interface StorageStructureValidator {
    public void validate();

    public static StorageStructureValidator New(StorageLiveFileProvider fileProvider, StorageChannelCountProvider channelCountProvider) {
        return new Default(fileProvider, channelCountProvider);
    }

    public static class Default
    implements StorageStructureValidator {
        private static final Logger logger = Logging.getLogger(StorageStructureValidator.class);
        private final StorageLiveFileProvider fileProvider;
        private final StorageChannelCountProvider channelCountProvider;
        private final String dataFileType;

        public Default(StorageLiveFileProvider fileProvider, StorageChannelCountProvider channelCountProvider) {
            this.fileProvider = fileProvider;
            this.channelCountProvider = channelCountProvider;
            this.dataFileType = this.fileProvider.fileNameProvider().dataFileType();
        }

        @Override
        public void validate() {
            if (this.fileProvider.baseDirectory().exists()) {
                if (this.fileProvider.baseDirectory().listDirectories().isEmpty()) {
                    logger.debug("Empty baseDirectory: {}", (Object)this.fileProvider.baseDirectory().toPathString());
                } else {
                    XGettingEnum<ADirectory> existingDirectories = this.getExistingChannelDirectories();
                    this.validateChannelCount(existingDirectories);
                    this.validateChannelDirectories(existingDirectories);
                }
            }
            logger.info("Storage structure validated successfully.");
        }

        private XGettingEnum<ADirectory> getExistingChannelDirectories() {
            XGettingEnum directories = this.fileProvider.baseDirectory().listDirectories();
            String channelDirectoryPrefix = this.fileProvider.fileNameProvider().channelDirectoryPrefix();
            EqHashEnum existingChannelDirs = (EqHashEnum)directories.filterTo((Consumer)EqHashEnum.New(), f -> f.identifier().startsWith(channelDirectoryPrefix));
            return existingChannelDirs;
        }

        private void validateChannelCount(XGettingEnum<ADirectory> directories) {
            if (directories.size() > 0L && directories.size() != (long)this.channelCountProvider.getChannelCount()) {
                throw new StorageExceptionStructureValidation("Found channels (" + directories.size() + ") don't match the configured channel count " + this.channelCountProvider.getChannelCount());
            }
            logger.debug("Configured channel count matches to storage");
        }

        private void validateChannelDirectories(XGettingEnum<ADirectory> directories) {
            directories.forEach(this::validateChannelDirectory);
            logger.debug("Channel directories are valid");
        }

        private void validateChannelDirectory(ADirectory channelDirectory) {
            if (!channelDirectory.listFiles().containsSearched(f -> f.identifier().endsWith(this.dataFileType))) {
                throw new StorageExceptionStructureValidation("No data file in channel directory " + channelDirectory.identifier() + " found!");
            }
        }
    }
}

