/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceIdSet;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageChannelTaskInitialize;
import org.eclipse.store.storage.types.StorageChannelTaskShutdown;
import org.eclipse.store.storage.types.StorageDataFileEvaluator;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageEntityTypeExportFileProvider;
import org.eclipse.store.storage.types.StorageEntityTypeHandler;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageObjectIdRangeEvaluator;
import org.eclipse.store.storage.types.StorageOperationController;
import org.eclipse.store.storage.types.StorageRequestTaskCacheCheck;
import org.eclipse.store.storage.types.StorageRequestTaskCreateStatistics;
import org.eclipse.store.storage.types.StorageRequestTaskExportChannels;
import org.eclipse.store.storage.types.StorageRequestTaskExportEntitiesByType;
import org.eclipse.store.storage.types.StorageRequestTaskFileCheck;
import org.eclipse.store.storage.types.StorageRequestTaskImportDataByteBuffers;
import org.eclipse.store.storage.types.StorageRequestTaskImportDataFiles;
import org.eclipse.store.storage.types.StorageRequestTaskLoadByOids;
import org.eclipse.store.storage.types.StorageRequestTaskLoadByTids;
import org.eclipse.store.storage.types.StorageRequestTaskLoadRoots;
import org.eclipse.store.storage.types.StorageRequestTaskStoreEntities;
import org.eclipse.store.storage.types.StorageRequestTaskTransactionsLogCleanup;
import org.eclipse.store.storage.types.StorageTimestampProvider;

public interface StorageRequestTaskCreator {
    public StorageChannelTaskInitialize createInitializationTask(int var1, StorageOperationController var2);

    public StorageRequestTaskStoreEntities createSaveTask(Binary var1, StorageOperationController var2);

    public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] var1, StorageOperationController var2);

    public StorageRequestTaskLoadRoots createRootsLoadTask(int var1, StorageOperationController var2);

    public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet var1, int var2, StorageOperationController var3);

    default public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider, StorageOperationController operationController) {
        return this.createExportTypesTask(channelCount, exportFileProvider, operationController);
    }

    public StorageRequestTaskExportEntitiesByType createExportTypesTask(int var1, StorageEntityTypeExportFileProvider var2, Predicate<? super StorageEntityTypeHandler> var3, StorageOperationController var4);

    public StorageRequestTaskExportChannels createTaskExportChannels(int var1, StorageLiveFileProvider var2, StorageOperationController var3);

    public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int var1, StorageOperationController var2);

    public StorageRequestTaskFileCheck createFullFileCheckTask(int var1, long var2, StorageOperationController var4);

    public StorageRequestTaskCacheCheck createFullCacheCheckTask(int var1, long var2, StorageEntityCacheEvaluator var4, StorageOperationController var5);

    public StorageRequestTaskTransactionsLogCleanup CreateTransactionsLogCleanupTask(int var1, StorageOperationController var2);

    public StorageRequestTaskImportDataFiles createImportFromFilesTask(int var1, StorageDataFileEvaluator var2, StorageObjectIdRangeEvaluator var3, XGettingEnum<AFile> var4, StorageOperationController var5);

    public StorageRequestTaskImportDataByteBuffers createImportFromByteBuffersTask(int var1, StorageDataFileEvaluator var2, StorageObjectIdRangeEvaluator var3, XGettingEnum<ByteBuffer> var4, StorageOperationController var5);

    public StorageChannelTaskShutdown createShutdownTask(int var1, StorageOperationController var2);

    public static final class Default
    implements StorageRequestTaskCreator {
        private final StorageTimestampProvider timestampProvider;

        public Default(StorageTimestampProvider timestampProvider) {
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
        }

        @Override
        public StorageChannelTaskInitialize createInitializationTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskInitialize.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageChannelTaskShutdown createShutdownTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskShutdown.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskStoreEntities createSaveTask(Binary data, StorageOperationController operationController) {
            return new StorageRequestTaskStoreEntities.Default(this.timestampProvider.currentNanoTimestamp(), data, operationController);
        }

        @Override
        public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] loadOids, StorageOperationController operationController) {
            return new StorageRequestTaskLoadByOids.Default(this.timestampProvider.currentNanoTimestamp(), loadOids, operationController);
        }

        @Override
        public StorageRequestTaskLoadRoots createRootsLoadTask(int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskLoadRoots.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet loadTids, int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskLoadByTids.Default(this.timestampProvider.currentNanoTimestamp(), loadTids, channelCount, operationController);
        }

        @Override
        public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType, StorageOperationController operationController) {
            return new StorageRequestTaskExportEntitiesByType.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, exportFileProvider, isExportType, operationController);
        }

        @Override
        public StorageRequestTaskExportChannels createTaskExportChannels(int channelCount, StorageLiveFileProvider fileProvider, StorageOperationController operationController) {
            return new StorageRequestTaskExportChannels.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, fileProvider, operationController);
        }

        @Override
        public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskCreateStatistics.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskFileCheck createFullFileCheckTask(int channelCount, long nanoTimeBudget, StorageOperationController operationController) {
            return new StorageRequestTaskFileCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget, operationController);
        }

        @Override
        public StorageRequestTaskCacheCheck createFullCacheCheckTask(int channelCount, long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator, StorageOperationController operationController) {
            return new StorageRequestTaskCacheCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget, entityEvaluator, operationController);
        }

        @Override
        public StorageRequestTaskTransactionsLogCleanup CreateTransactionsLogCleanupTask(int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskTransactionsLogCleanup.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskImportDataFiles createImportFromFilesTask(int channelCount, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<AFile> importFiles, StorageOperationController operationController) {
            return new StorageRequestTaskImportDataFiles.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, objectIdRangeEvaluator, importFiles, operationController);
        }

        @Override
        public StorageRequestTaskImportDataByteBuffers createImportFromByteBuffersTask(int channelCount, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<ByteBuffer> importData, StorageOperationController operationController) {
            return new StorageRequestTaskImportDataByteBuffers.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, objectIdRangeEvaluator, importData, operationController);
        }
    }
}

