/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.Date;
import org.eclipse.serializer.collections.XUtilsCollection;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.time.XTime;
import org.eclipse.store.storage.types.StorageChannel;
import org.eclipse.store.storage.types.StorageChannelSynchronizingTask;
import org.eclipse.store.storage.types.StorageOperationController;
import org.eclipse.store.storage.types.StorageRawFileStatistics;
import org.eclipse.store.storage.types.StorageRequestTask;

public interface StorageRequestTaskCreateStatistics
extends StorageRequestTask {
    public StorageRawFileStatistics result();

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<StorageRawFileStatistics.ChannelStatistics>
    implements StorageRequestTaskCreateStatistics {
        private final Date creationTime;
        private final StorageRawFileStatistics.ChannelStatistics[] channelResults;
        private StorageRawFileStatistics result;

        Default(long timestamp, int channelCount, StorageOperationController controller) {
            super(timestamp, channelCount, controller);
            this.channelResults = new StorageRawFileStatistics.ChannelStatistics[channelCount];
            this.creationTime = XTime.now();
        }

        @Override
        protected final StorageRawFileStatistics.ChannelStatistics internalProcessBy(StorageChannel channel) {
            return channel.createRawFileStatistics();
        }

        @Override
        protected synchronized void succeed(StorageChannel channel, StorageRawFileStatistics.ChannelStatistics result) {
            this.channelResults[channel.channelIndex()] = result;
        }

        @Override
        public synchronized StorageRawFileStatistics result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        private StorageRawFileStatistics createResult() {
            long fileCount = 0L;
            long liveDataLength = 0L;
            long totalDataLength = 0L;
            for (StorageRawFileStatistics.ChannelStatistics result : this.channelResults) {
                fileCount += result.fileCount();
                liveDataLength += result.liveDataLength();
                totalDataLength += result.totalDataLength();
            }
            return StorageRawFileStatistics.New(this.creationTime, fileCount, liveDataLength, totalDataLength, (XGettingTable<Integer, ? extends StorageRawFileStatistics.ChannelStatistics>)XUtilsCollection.toTable((Object[])this.channelResults));
        }
    }
}

