/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageBackupItemEnqueuer;
import org.eclipse.store.storage.types.StorageFileProvider;
import org.eclipse.store.storage.types.StorageFileWriter;
import org.eclipse.store.storage.types.StorageImportSource;
import org.eclipse.store.storage.types.StorageLiveChannelFile;
import org.eclipse.store.storage.types.StorageLiveDataFile;
import org.eclipse.store.storage.types.StorageLiveTransactionsFile;
import org.eclipse.store.storage.types.StorageWriteController;

public interface StorageFileWriterBackupping
extends StorageFileWriter {
    public static Provider Provider(StorageBackupItemEnqueuer backupItemEnqueuer, StorageFileWriter.Provider wrappedProvider) {
        return new Provider.Default((StorageBackupItemEnqueuer)X.notNull((Object)backupItemEnqueuer), (StorageFileWriter.Provider)X.notNull((Object)wrappedProvider));
    }

    public static interface Provider
    extends StorageFileWriter.Provider {

        public static final class Default
        implements Provider {
            final StorageBackupItemEnqueuer backupItemEnqueuer;
            final StorageFileWriter.Provider wrappedProvider;

            Default(StorageBackupItemEnqueuer backupItemEnqueuer, StorageFileWriter.Provider wrappedProvider) {
                this.backupItemEnqueuer = backupItemEnqueuer;
                this.wrappedProvider = wrappedProvider;
            }

            @Override
            public StorageFileWriter provideWriter(int channelIndex) {
                StorageFileWriter delegateWriter = this.wrappedProvider.provideWriter(channelIndex);
                return new org.eclipse.store.storage.types.StorageFileWriterBackupping$Default(delegateWriter, this.backupItemEnqueuer);
            }

            @Override
            public StorageFileWriter provideWriter() {
                return this.wrappedProvider.provideWriter();
            }
        }
    }

    public static final class Default
    implements StorageFileWriter {
        private final StorageFileWriter delegate;
        private final StorageBackupItemEnqueuer itemEnqueuer;

        Default(StorageFileWriter delegate, StorageBackupItemEnqueuer itemEnqueuer) {
            this.delegate = delegate;
            this.itemEnqueuer = itemEnqueuer;
        }

        @Override
        public final long writeStore(StorageLiveDataFile targetFile, Iterable<? extends ByteBuffer> byteBuffers) {
            long oldTargetFileLength = targetFile.size();
            long byteCount = this.delegate.writeStore(targetFile, byteBuffers);
            this.itemEnqueuer.enqueueCopyingItem(targetFile, oldTargetFileLength, byteCount);
            return byteCount;
        }

        @Override
        public final long writeImport(StorageImportSource source, long sourceOffset, long copyLength, StorageLiveDataFile targetFile) {
            long oldTargetFileLength = targetFile.size();
            this.delegate.writeImport(source, sourceOffset, copyLength, targetFile);
            this.itemEnqueuer.enqueueCopyingItem(targetFile, oldTargetFileLength, copyLength);
            return copyLength;
        }

        @Override
        public final long writeTransfer(StorageLiveDataFile sourceFile, long sourceOffset, long length, StorageLiveDataFile targetFile) {
            long oldTargetFileLength = targetFile.size();
            this.delegate.writeTransfer(sourceFile, sourceOffset, length, targetFile);
            this.itemEnqueuer.enqueueCopyingItem(targetFile, oldTargetFileLength, length);
            return length;
        }

        @Override
        public final long writeTransactionEntryCreate(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile) {
            long oldLength = transactionFile.size();
            long byteCount = this.delegate.writeTransactionEntryCreate(transactionFile, byteBuffers, dataFile);
            this.itemEnqueuer.enqueueCopyingItem(transactionFile, oldLength, byteCount);
            return byteCount;
        }

        @Override
        public final long writeTransactionEntryStore(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile, long dataFileOffset, long storeLength) {
            long oldLength = transactionFile.size();
            long byteCount = this.delegate.writeTransactionEntryStore(transactionFile, byteBuffers, dataFile, dataFileOffset, storeLength);
            this.itemEnqueuer.enqueueCopyingItem(transactionFile, oldLength, byteCount);
            return byteCount;
        }

        @Override
        public final long writeTransactionEntryTransfer(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile, long dataFileOffset, long storeLength) {
            long oldLength = transactionFile.size();
            long byteCount = this.delegate.writeTransactionEntryTransfer(transactionFile, byteBuffers, dataFile, dataFileOffset, storeLength);
            this.itemEnqueuer.enqueueCopyingItem(transactionFile, oldLength, byteCount);
            return byteCount;
        }

        @Override
        public final long writeTransactionEntryDelete(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile) {
            long oldLength = transactionFile.size();
            long byteCount = this.delegate.writeTransactionEntryDelete(transactionFile, byteBuffers, dataFile);
            this.itemEnqueuer.enqueueCopyingItem(transactionFile, oldLength, byteCount);
            return byteCount;
        }

        @Override
        public final long writeTransactionEntryTruncate(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile file, long newFileLength) {
            long oldLength = transactionFile.size();
            long byteCount = this.delegate.writeTransactionEntryTruncate(transactionFile, byteBuffers, file, newFileLength);
            this.itemEnqueuer.enqueueCopyingItem(transactionFile, oldLength, byteCount);
            return byteCount;
        }

        @Override
        public final void truncate(StorageLiveChannelFile<?> file, long newLength, StorageFileProvider fileProvider) {
            this.delegate.truncate(file, newLength, fileProvider);
            this.itemEnqueuer.enqueueTruncatingItem(file, newLength);
        }

        @Override
        public void delete(StorageLiveDataFile file, StorageWriteController writeController, StorageFileProvider fileProvider) {
            this.delegate.delete(file, writeController, fileProvider);
            this.itemEnqueuer.enqueueDeletionItem(file);
        }
    }
}

