/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageChannel;
import org.slf4j.Logger;

@FunctionalInterface
public interface StorageExceptionHandler {
    public void handleException(Throwable var1, StorageChannel var2);

    public static void defaultHandleException(Throwable exception, StorageChannel channel) {
        if (exception instanceof StorageException) {
            throw (StorageException)((Object)exception);
        }
        throw new StorageException(exception);
    }

    public static StorageExceptionHandler New() {
        return new Default();
    }

    public static final class Default
    implements StorageExceptionHandler {
        private static final Logger logger = Logging.getLogger(StorageExceptionHandler.class);

        Default() {
        }

        @Override
        public void handleException(Throwable exception, StorageChannel channel) {
            logger.error("Exception occurred in storage channel#{}", (Object)channel.channelIndex(), (Object)exception);
            StorageExceptionHandler.defaultHandleException(exception, channel);
        }
    }
}

