/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import org.eclipse.serializer.meta.XDebug;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageChannel;
import org.eclipse.store.storage.types.StorageEntityCache;
import org.eclipse.store.storage.types.StorageHashChannelPart;

public interface StorageEventLogger {
    default public void logChannelProcessingDisabled(StorageChannel channel) {
    }

    default public void logChannelStoppedWorking(StorageChannel channel) {
    }

    default public void logDisruption(StorageChannel channel, Throwable t) {
    }

    default public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorNotNeeded() {
    }

    default public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
    }

    default public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
    }

    default public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
    }

    public static StorageEventLogger NoOp() {
        return new NoOp();
    }

    public static StorageEventLogger Default() {
        return new Default(Default::printString);
    }

    public static StorageEventLogger Default(Consumer<? super String> messageConsumer) {
        return new Default((Consumer)X.notNull(messageConsumer));
    }

    public static StorageEventLogger Debug() {
        return new Debug(Default::printString);
    }

    public static StorageEventLogger Debug(Consumer<? super String> messageConsumer) {
        return new Debug((Consumer)X.notNull(messageConsumer));
    }

    public static StorageEventLogger Chain(StorageEventLogger first, StorageEventLogger second) {
        return new Chaining((StorageEventLogger)X.notNull((Object)first), (StorageEventLogger)X.notNull((Object)second));
    }

    public static final class Chaining
    implements StorageEventLogger {
        private final StorageEventLogger first;
        private final StorageEventLogger second;

        Chaining(StorageEventLogger first, StorageEventLogger second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void logChannelProcessingDisabled(StorageChannel channel) {
            this.first.logChannelProcessingDisabled(channel);
            this.second.logChannelProcessingDisabled(channel);
        }

        @Override
        public void logChannelStoppedWorking(StorageChannel channel) {
            this.first.logChannelStoppedWorking(channel);
            this.second.logChannelStoppedWorking(channel);
        }

        @Override
        public void logDisruption(StorageChannel channel, Throwable t) {
            this.first.logDisruption(channel, t);
            this.second.logDisruption(channel, t);
        }

        @Override
        public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
            this.first.logLiveCheckComplete(entityCache);
            this.second.logLiveCheckComplete(entityCache);
        }

        @Override
        public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
            this.first.logGarbageCollectorSweepingComplete(entityCache);
            this.second.logGarbageCollectorSweepingComplete(entityCache);
        }

        @Override
        public void logGarbageCollectorNotNeeded() {
            this.first.logGarbageCollectorNotNeeded();
            this.second.logGarbageCollectorNotNeeded();
        }

        @Override
        public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
            this.first.logGarbageCollectorCompletedHotPhase(gcHotGeneration, lastGcHotCompletion);
            this.second.logGarbageCollectorCompletedHotPhase(gcHotGeneration, lastGcHotCompletion);
        }

        @Override
        public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
            this.first.logGarbageCollectorCompleted(gcColdGeneration, lastGcColdCompletion);
            this.second.logGarbageCollectorCompleted(gcColdGeneration, lastGcColdCompletion);
        }

        @Override
        public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
            this.first.logGarbageCollectorEncounteredZombieObjectId(objectId);
            this.second.logGarbageCollectorEncounteredZombieObjectId(objectId);
        }
    }

    public static class Debug
    extends Default {
        Debug(Consumer<? super String> messageConsumer) {
            super(messageConsumer);
        }

        @Override
        public void logChannelProcessingDisabled(StorageChannel channel) {
            this.log(Debug.toChannelIdentifier(channel) + " processing disabled.");
        }

        @Override
        public void logChannelStoppedWorking(StorageChannel channel) {
            this.log(Debug.toChannelIdentifier(channel) + " stopped working.");
        }

        @Override
        public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
            this.log(Debug.toChannelIdentifier(entityCache) + " completed live check.");
        }

        @Override
        public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
            this.log(Debug.toChannelIdentifier(entityCache) + " completed sweeping.");
        }

        @Override
        public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
            this.log("GC marking encountered zombie ObjectId " + objectId);
        }

        @Override
        public void logGarbageCollectorNotNeeded() {
            this.log("not needed.");
        }

        @Override
        public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
            this.log("Completed GC Hot Phase #" + gcHotGeneration + " @ " + lastGcHotCompletion);
        }

        @Override
        public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
            this.log("Storage-GC completed #" + gcColdGeneration + " @ " + lastGcColdCompletion);
        }
    }

    public static class Default
    implements StorageEventLogger {
        protected final Consumer<? super String> messageConsumer;

        public static void printString(String s) {
            XDebug.println((String)s, (int)4);
        }

        public static String toChannelIdentifier(StorageChannel channel) {
            return Default.toChannelPartIdentifier(channel);
        }

        public static String toChannelIdentifier(StorageEntityCache<?> entityCache) {
            return Default.toChannelPartIdentifier(entityCache);
        }

        public static String toChannelPartIdentifier(StorageHashChannelPart channelPart) {
            return StorageChannel.class.getSimpleName() + "#" + channelPart.channelIndex();
        }

        public static String stackTraceToString(Throwable t) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            t.printStackTrace(printWriter);
            return printWriter.toString();
        }

        Default(Consumer<? super String> messageConsumer) {
            this.messageConsumer = (Consumer)X.notNull(messageConsumer);
        }

        public void log(String s) {
            this.messageConsumer.accept(s);
        }

        @Override
        public void logDisruption(StorageChannel channel, Throwable t) {
            this.log(Default.toChannelIdentifier(channel) + " encountered disrupting exception " + t);
            t.printStackTrace();
        }
    }

    public static final class NoOp
    implements StorageEventLogger {
        NoOp() {
        }
    }
}

