/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryReferenceTraverser;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.store.storage.exceptions.StorageExceptionInvalidEntityLength;

public interface StorageEntityTypeHandler
extends PersistenceTypeDefinition {
    public long simpleReferenceCount();

    public void iterateReferences(long var1, PersistenceObjectIdAcceptor var3);

    public void validateEntity(long var1, long var3, long var5);

    public boolean isValidEntityGuaranteedType(long var1, long var3);

    public void validateEntityGuaranteedType(long var1, long var3);

    public long minimumLength();

    public long maximumLength();

    default public boolean hasPersistedVariableLength() {
        return this.minimumLength() != this.maximumLength();
    }

    public static final class Default
    implements StorageEntityTypeHandler {
        private final PersistenceTypeDefinition typeDefinition;
        private final BinaryReferenceTraverser[] referenceTraversers;
        private final int simpleReferenceCount;
        private final long simpleReferenceRange;
        private final long minimumEntityLength;
        private final long maximumEntityLength;
        private final boolean hasReferences;
        private final boolean isPrimitive;
        private final boolean hasVariableLength;
        private final boolean switchByteOrder;

        public Default(PersistenceTypeDefinition typeDefinition, boolean switchByteOrder) {
            BinaryReferenceTraverser[] referenceTraversers = Default.deriveReferenceTraversers((XGettingEnum<? extends PersistenceTypeDefinitionMember>)typeDefinition.instanceMembers(), switchByteOrder);
            this.typeDefinition = typeDefinition;
            this.isPrimitive = typeDefinition.isPrimitiveType();
            this.hasReferences = typeDefinition.hasPersistedReferences();
            this.simpleReferenceCount = BinaryReferenceTraverser.Static.calculateSimpleReferenceCount((BinaryReferenceTraverser[])referenceTraversers);
            this.simpleReferenceRange = this.simpleReferenceCount * Binary.objectIdByteLength();
            this.referenceTraversers = BinaryReferenceTraverser.Static.cropToReferences((BinaryReferenceTraverser[])referenceTraversers);
            this.minimumEntityLength = XMath.addCapped((long)Binary.entityHeaderLength(), (long)typeDefinition.membersPersistedLengthMinimum());
            this.maximumEntityLength = XMath.addCapped((long)Binary.entityHeaderLength(), (long)typeDefinition.membersPersistedLengthMaximum());
            this.hasVariableLength = this.minimumEntityLength != this.maximumEntityLength;
            this.switchByteOrder = switchByteOrder;
        }

        static final BinaryReferenceTraverser[] deriveReferenceTraversers(XGettingEnum<? extends PersistenceTypeDefinitionMember> typeDefMembers, boolean switchByteOrder) {
            return BinaryReferenceTraverser.Static.deriveReferenceTraversers(typeDefMembers, (boolean)switchByteOrder);
        }

        public final long typeId() {
            return this.typeDefinition.typeId();
        }

        public final String typeName() {
            return this.typeDefinition.typeName();
        }

        public final Class<?> type() {
            return this.typeDefinition.type();
        }

        public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
            return this.typeDefinition.allMembers();
        }

        public final XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers() {
            return this.typeDefinition.instanceMembers();
        }

        public final long membersPersistedLengthMinimum() {
            return this.typeDefinition.membersPersistedLengthMinimum();
        }

        public final long membersPersistedLengthMaximum() {
            return this.typeDefinition.membersPersistedLengthMaximum();
        }

        @Override
        public final void iterateReferences(long entityCacheAddress, PersistenceObjectIdAcceptor acceptor) {
            if (this.simpleReferenceRange != 0L) {
                this.iterateSimpleReferences(entityCacheAddress, acceptor);
            } else {
                BinaryReferenceTraverser.iterateReferences((long)Binary.toEntityContentOffset((long)entityCacheAddress), (BinaryReferenceTraverser[])this.referenceTraversers, (PersistenceObjectIdAcceptor)acceptor);
            }
        }

        private void iterateSimpleReferences(long entityCacheAddress, PersistenceObjectIdAcceptor acceptor) {
            if (this.switchByteOrder) {
                BinaryReferenceTraverser.iterateReferenceRangeReversed((long)Binary.toEntityContentOffset((long)entityCacheAddress), (long)this.simpleReferenceRange, (PersistenceObjectIdAcceptor)acceptor);
            } else {
                BinaryReferenceTraverser.iterateReferenceRange((long)Binary.toEntityContentOffset((long)entityCacheAddress), (long)this.simpleReferenceRange, (PersistenceObjectIdAcceptor)acceptor);
            }
        }

        @Override
        public final void validateEntity(long length, long typeId, long objectId) {
            this.validateEntityGuaranteedType(length, objectId);
        }

        @Override
        public boolean isValidEntityGuaranteedType(long length, long objectId) {
            if (length < this.minimumEntityLength) {
                return false;
            }
            return length <= this.maximumEntityLength;
        }

        @Override
        public final void validateEntityGuaranteedType(long length, long objectId) {
            if (length < this.minimumEntityLength) {
                throw new StorageExceptionInvalidEntityLength("Invalid entity length for objectId " + objectId + " of type " + this.toRuntimeTypeIdentifier() + " : " + length + " < " + this.minimumEntityLength);
            }
            if (length > this.maximumEntityLength) {
                throw new StorageExceptionInvalidEntityLength("Invalid entity length for objectId " + objectId + " of type " + this.toRuntimeTypeIdentifier() + " : " + length + " > " + this.maximumEntityLength);
            }
        }

        public final boolean hasPersistedReferences() {
            return this.hasReferences;
        }

        public final boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        @Override
        public final boolean hasPersistedVariableLength() {
            return this.hasVariableLength;
        }

        public final boolean hasVaryingPersistedLengthInstances() {
            return this.hasVariableLength;
        }

        @Override
        public final long simpleReferenceCount() {
            return this.simpleReferenceCount;
        }

        @Override
        public final long minimumLength() {
            return this.minimumEntityLength;
        }

        @Override
        public final long maximumLength() {
            return this.maximumEntityLength;
        }

        public String toString() {
            return this.typeName();
        }
    }
}

