/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.util.X;

public interface StorageEntityTypeConversionFileProvider {
    public AWritableFile provideConversionFile(PersistenceTypeDefinition var1, AFile var2);

    public static StorageEntityTypeConversionFileProvider New(ADirectory directory, String fileSuffix) {
        return new Default((ADirectory)X.notNull((Object)directory), (String)XChars.notEmpty((CharSequence)fileSuffix));
    }

    public static final class Default
    implements StorageEntityTypeConversionFileProvider {
        private final ADirectory directory;
        private final String fileSuffix;

        public Default(ADirectory directory, String fileSuffix) {
            this.directory = (ADirectory)X.notNull((Object)directory);
            this.fileSuffix = fileSuffix;
        }

        public final String fileSuffix() {
            return this.fileSuffix;
        }

        @Override
        public AWritableFile provideConversionFile(PersistenceTypeDefinition typeDescription, AFile sourceFile) {
            String fileName = typeDescription.typeName() + "_" + typeDescription.typeId();
            AFile targetFile = this.directory.ensureFile(fileName, this.fileSuffix);
            targetFile.ensureExists();
            return targetFile.useWriting();
        }
    }
}

